/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.schedulemanager.provider;

import com.digiwin.app.schedule.entity.DWJobResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.schedulemanager.core.aop.MyExceptionHandler;
import com.digiwin.athena.schedulemanager.core.aop.RouterKey;
import com.digiwin.athena.schedulemanager.core.util.StringUtil;
import com.digiwin.athena.schedulemanager.producer.MessageProducer;
import com.digiwin.athena.schedulemanager.provider.IExecuteService;
import com.digiwin.athena.schedulemanager.service.srp.IScheduleDefineService;
import com.digiwin.athena.schedulemanager.util.JsonUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="scheduleExecuteService")
@MyExceptionHandler
public class ExecuteService
implements IExecuteService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteService.class);
    private MessageProducer rabbitMQProducer;
    private IScheduleDefineService defineService;

    public ExecuteService(MessageProducer rabbitMQProducer, IScheduleDefineService defineService) {
        this.rabbitMQProducer = rabbitMQProducer;
        this.defineService = defineService;
    }

    @Override
    @RouterKey
    public DWJobResult post(Map<String, Object> paramMap) {
        return this.executeJob(paramMap);
    }

    @Override
    public DWJobResult postExecuteRemoteJob(Map<String, Object> param) {
        DWJobResult result = new DWJobResult();
        String messageBody = this.sendMessage(param);
        result.setMessage(messageBody);
        result.setExecuteStatus("completed");
        LOGGER.info("remoteJob\u6392\u7a0b\u63a5\u6536\u5230\u6d88\u606f\u53d1\u9001\u5230MQ\uff1a{}, routerKey\uff1a{}", param, DWServiceContext.getContext().getRequestHeader().get("routerKey"));
        return result;
    }

    public DWJobResult executeJob(Map<String, Object> paramMap) {
        String instanceId;
        String ruleId = paramMap.get("ruleId") == null ? "" : String.valueOf(paramMap.get("ruleId"));
        String string = instanceId = paramMap.get("instance_id") == null ? "" : String.valueOf(paramMap.get("instance_id"));
        if (!StringUtil.isEmpty(ruleId) && !StringUtil.isEmpty(instanceId) && this.defineService.isNotExist(ruleId, instanceId)) {
            LOGGER.error("\u5b58\u5728\u65e0\u6548\u7684\u6392\u7a0b: {}", paramMap);
            return null;
        }
        DWJobResult result = new DWJobResult();
        String messageBody = this.sendMessage(paramMap);
        result.setMessage(messageBody);
        result.setExecuteStatus("completed");
        LOGGER.info("job\u6392\u7a0b\u63a5\u6536\u5230\u6d88\u606f\u53d1\u9001\u5230MQ\uff1a{}, routerKey\uff1a{}", paramMap, DWServiceContext.getContext().getRequestHeader().get("routerKey"));
        return result;
    }

    private String sendMessage(Map<String, Object> paramMap) {
        String messageId = this.rabbitMQProducer.sendMessage(paramMap);
        paramMap.put("messageId", messageId);
        return JsonUtil.getJsonString(paramMap);
    }
}

