/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.schedulemanager.service.facade.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.schedulemanager.core.dict.TypeDict;
import com.digiwin.athena.schedulemanager.core.message.ErrorCode;
import com.digiwin.athena.schedulemanager.core.util.CollectionUtil;
import com.digiwin.athena.schedulemanager.core.util.StringUtil;
import com.digiwin.athena.schedulemanager.dto.ScheduleCompareDto;
import com.digiwin.athena.schedulemanager.pojo.request.BatchScheduleReq;
import com.digiwin.athena.schedulemanager.pojo.request.CrossReq;
import com.digiwin.athena.schedulemanager.pojo.request.ScheduleReq;
import com.digiwin.athena.schedulemanager.pojo.request.ScheduleUpdateReq;
import com.digiwin.athena.schedulemanager.pojo.request.TriggerReq;
import com.digiwin.athena.schedulemanager.repository.model.ScheduleDetailModel;
import com.digiwin.athena.schedulemanager.service.client.IDwScheduleClient;
import com.digiwin.athena.schedulemanager.service.facade.IScheduleFacadeService;
import com.digiwin.athena.schedulemanager.service.srp.IScheduleDefineService;
import com.digiwin.athena.schedulemanager.service.srp.IScheduleLogService;
import com.digiwin.athena.schedulemanager.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="scheduleFacadeService")
public class ScheduleFacadeService
implements IScheduleFacadeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduleFacadeService.class);
    private IDwScheduleClient dapClient;
    private IScheduleLogService logService;
    private IScheduleDefineService defineService;

    public ScheduleFacadeService(IDwScheduleClient dapClient, IScheduleLogService logService, IScheduleDefineService defineService) {
        this.dapClient = dapClient;
        this.logService = logService;
        this.defineService = defineService;
    }

    @Override
    @Transactional(value="schedule-dw-transactionManager")
    public void createSchedule(BatchScheduleReq rule) {
        rule.getRuleList().forEach(request -> this.createQuartzSchedule(rule.getTenantId(), request.getRuleId(), request.getActionId(), StringUtil.isEmpty(request.getEnableStatus()) ? "Y" : request.getEnableStatus(), request.getTriggers(), request.getCaller(), request.getScheduleParam()));
    }

    private void createQuartzSchedule(String tenantId, String ruleId, String actionId, String enableStatus, List<TriggerReq> triggerList, String caller, JSONObject param) {
        ArrayList<Map<String, Object>> scheduleParamList = new ArrayList<Map<String, Object>>();
        triggerList.forEach(trigger -> {
            String instanceId = UUID.randomUUID().toString();
            Map<String, Object> scheduleParam = this.initScheduleParam(instanceId, tenantId, ruleId, enableStatus, caller, param);
            Map<String, Object> scheduleDetail = this.getScheduleDetail((TriggerReq)trigger);
            scheduleParam.putAll(scheduleDetail);
            scheduleParamList.add(scheduleParam);
            this.saveScheduleDefine(tenantId, ruleId, actionId, instanceId, JsonUtil.getJsonString(trigger), StringUtil.isEmpty(caller) ? "MonitorEngine" : caller, 1);
        });
        String result = this.dapClient.addQuartz(scheduleParamList, "addSchedules");
        JSONObject resultObj = JsonUtil.getObject(result);
        boolean isSuccess = 200 == resultObj.getIntValue("status");
        scheduleParamList.forEach(scheduleParam -> this.logService.saveScheduleLog(String.valueOf(scheduleParam.get("schedule_id")), 1, "MonitorEngine", isSuccess ? 1 : 0));
        if (!isSuccess) {
            LOGGER.error("\u8c03\u7528api\u521b\u5efa\u6392\u7a0b\u5931\u8d25\uff01{}", (Object)result);
            throw new DWRuntimeException(ErrorCode.ERROR_SCHEDULE_CREATE_CODE.getCode(), ErrorCode.ERROR_SCHEDULE_CREATE_CODE.getMessage());
        }
    }

    private Map<String, Object> initScheduleParam(String scheduleId, String tenantId, String ruleId, String enableStatus, String caller, JSONObject param) {
        HashMap<String, String> scheduleParam = new HashMap<String, String>(4);
        scheduleParam.put("tenantId", tenantId);
        scheduleParam.put("ruleId", ruleId);
        scheduleParam.put("instance_id", scheduleId);
        scheduleParam.put("caller", caller);
        scheduleParam.put("scheduleParam", (String)param);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("schedule_param", scheduleParam);
        paramMap.put("schedule_id", scheduleId);
        paramMap.put("job_name", "IExecuteService");
        paramMap.put("enable_status", enableStatus);
        paramMap.put("module_name", "ScheduleManager");
        return paramMap;
    }

    @Override
    @Transactional(value="schedule-dw-transactionManager")
    public void updateSchedule(ScheduleUpdateReq rule, String enableStatus) {
        List<ScheduleDetailModel> updateList = this.defineService.getScheduleInfoByRuleId(rule.getRuleId());
        this.updateTriggers(rule, enableStatus, updateList);
    }

    private void updateTriggers(ScheduleUpdateReq rule, String enableStatus, List<ScheduleDetailModel> sourceSchedule) {
        ScheduleCompareDto scheduleCompareDto = this.handleScheduleDifference(rule, sourceSchedule);
        if (CollectionUtil.isNotEmpty(scheduleCompareDto.getSourceScheduleMap())) {
            this.executeSchedule(scheduleCompareDto.getSourceScheduleMap().values(), 4);
        }
        if (CollectionUtil.isNotEmpty(scheduleCompareDto.getAddSchedules())) {
            if (StringUtil.isBlank(enableStatus)) {
                enableStatus = "Y";
            }
            this.createQuartzSchedule(rule.getTenantId(), rule.getRuleId(), rule.getActionId(), enableStatus, scheduleCompareDto.getAddSchedules(), rule.getCaller(), rule.getScheduleParam());
        }
        if (CollectionUtil.isNotEmpty(scheduleCompareDto.getExistsSchedules())) {
            int callType = "N".equals(enableStatus) ? 3 : 5;
            this.executeSchedule(scheduleCompareDto.getExistsSchedules(), callType);
        }
    }

    private ScheduleCompareDto handleScheduleDifference(ScheduleUpdateReq requestDetail, List<ScheduleDetailModel> sourceSchedule) {
        HashMap<JSONObject, ScheduleDetailModel> sourceScheduleMap = new HashMap<JSONObject, ScheduleDetailModel>(4);
        sourceSchedule.forEach(schedule -> sourceScheduleMap.put(JsonUtil.getObject(schedule.getTriggers()), (ScheduleDetailModel)schedule));
        ArrayList<TriggerReq> addSchedules = new ArrayList<TriggerReq>();
        ArrayList<ScheduleDetailModel> existsSchedules = new ArrayList<ScheduleDetailModel>();
        requestDetail.getTriggers().forEach(trigger -> {
            JSONObject key = JsonUtil.getObject(JsonUtil.getJsonString(trigger));
            ScheduleDetailModel existsScheduleDetail = (ScheduleDetailModel)sourceScheduleMap.remove(key);
            if (null != existsScheduleDetail) {
                existsSchedules.add(existsScheduleDetail);
            } else {
                addSchedules.add((TriggerReq)trigger);
            }
        });
        LOGGER.info("ScheduleFacadeService#handleScheduleDifference sourceScheduleMap  :{},addSchedules  :{}, existsSchedules  :{} ", new Object[]{sourceScheduleMap.size(), addSchedules.size(), existsSchedules.size()});
        ScheduleCompareDto scheduleCompareDto = new ScheduleCompareDto();
        scheduleCompareDto.setSourceScheduleMap(sourceScheduleMap);
        scheduleCompareDto.setAddSchedules(addSchedules);
        scheduleCompareDto.setExistsSchedules(existsSchedules);
        return scheduleCompareDto;
    }

    @Override
    @Transactional(value="schedule-dw-transactionManager")
    public void deleteSchedule(ScheduleReq rule) {
        this.handleSchedule(rule, 4);
    }

    @Override
    public void stopSchedule(ScheduleReq rule) {
        this.handleSchedule(rule, 3);
    }

    @Override
    public void startSchedule(ScheduleReq rule) {
        this.handleSchedule(rule, 5);
    }

    @Override
    public void deleteScheduleCross(CrossReq cross) {
        this.dapClient.deleteQuartzCross(cross);
    }

    @Override
    public JSONObject getSchedule(ScheduleReq rule) {
        List<ScheduleDetailModel> list = this.defineService.getScheduleInfoByRuleId(rule.getRuleId());
        if (CollectionUtil.isEmpty(list)) {
            return new JSONObject();
        }
        return this.getDapScheduleList(list);
    }

    private JSONObject getDapScheduleList(List<ScheduleDetailModel> list) {
        JSONObject result = new JSONObject();
        List<String> scheduleIdList = list.stream().map(ScheduleDetailModel::getInstanceId).collect(Collectors.toList());
        String response = this.dapClient.getQuartz(scheduleIdList);
        JSONObject resultObj = JsonUtil.getObject(response);
        JSONArray schedules = new JSONArray();
        if (200 == resultObj.getIntValue("status")) {
            schedules = resultObj.getJSONArray("response");
            result.put("dataList", (Object)schedules);
        }
        result.put("enable_status", (Object)(schedules.isEmpty() ? "" : schedules.getJSONObject(0).getJSONObject("data").getString("enable_status")));
        return result;
    }

    private void handleSchedule(ScheduleReq rule, int callType) {
        List<ScheduleDetailModel> list = this.defineService.getScheduleInfoByRuleId(rule.getRuleId());
        if (CollectionUtil.isEmpty(list)) {
            LOGGER.warn("\u901a\u8fc7\u6761\u4ef6{}\u67e5\u8be2\uff0c\u6682\u65e0\u5339\u914d\u6392\u7a0b\u8bb0\u5f55", (Object)rule);
            return;
        }
        boolean result = this.executeSchedule(list, callType);
        if (!result) {
            throw new DWRuntimeException(ErrorCode.ERROR_SCHEDULE_HANDLE_CODE.getCode(), ErrorCode.ERROR_SCHEDULE_HANDLE_CODE.getMessage());
        }
    }

    private boolean executeSchedule(Collection<ScheduleDetailModel> list, int callType) {
        boolean isSuccess;
        List<String> scheduleIdList = list.stream().map(ScheduleDetailModel::getInstanceId).collect(Collectors.toList());
        String result = this.dapClient.executeQuartz(scheduleIdList, TypeDict.getMethodName(callType));
        JSONObject resultObj = JsonUtil.getObject(result);
        boolean bl = isSuccess = 200 == resultObj.getIntValue("status");
        if (4 == callType && isSuccess) {
            scheduleIdList.forEach(instanceId -> this.defineService.deleteScheduleDefine((String)instanceId));
        }
        int flag = isSuccess ? 1 : 0;
        scheduleIdList.forEach(instanceId -> this.logService.saveScheduleLog((String)instanceId, callType, "MonitorEngine", flag));
        return isSuccess;
    }

    private Map<String, Object> getScheduleDetail(TriggerReq trigger) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        if (StringUtil.isNotBlank(trigger.getAssignTime())) {
            paramMap.put("schedule_type", 1);
            paramMap.put("assign_time", trigger.getAssignTime());
        } else if (StringUtil.isNotBlank(trigger.getMonth()) || StringUtil.isNotBlank(trigger.getWeekOfMonth()) || StringUtil.isNotBlank(trigger.getDayOfWeek()) || StringUtil.isNotBlank(trigger.getDayOfMonth()) || StringUtil.isNotBlank(trigger.getTime()) || StringUtil.isNotBlank(trigger.getTime2()) || StringUtil.isNotBlank(trigger.getTime3()) || StringUtil.isNotBlank(trigger.getTime1())) {
            paramMap.put("schedule_type", 2);
            paramMap.put("month", trigger.getMonth());
            paramMap.put("week_of_month", trigger.getMonth());
            paramMap.put("day_of_week", trigger.getDayOfWeek());
            paramMap.put("day_of_month", trigger.getDayOfMonth());
            paramMap.put("time", trigger.getTime());
            paramMap.put("time1", trigger.getTime1());
            paramMap.put("time2", trigger.getTime2());
            paramMap.put("time3", trigger.getTime3());
        } else if (StringUtil.isNotBlank(trigger.getRepeatType())) {
            paramMap.put("schedule_type", 3);
            paramMap.put("start_time", trigger.getStartTime());
            paramMap.put("end_time", trigger.getEndTime());
            paramMap.put("repeat_type", trigger.getRepeatType());
            paramMap.put("repeat_count", trigger.getRepeatCount());
            paramMap.put("frequency", trigger.getFrequency());
        } else {
            paramMap.put("schedule_type", 4);
            paramMap.put("start_time", trigger.getStartTime());
            paramMap.put("end_time", trigger.getEndTime());
            paramMap.put("repeat_count", trigger.getRepeatCount());
            paramMap.put("minutely", trigger.getMinutely());
            paramMap.put("hourly", trigger.getHourly());
            paramMap.put("daily", trigger.getDaily());
            paramMap.put("weekly", trigger.getWeekly());
            paramMap.put("byday", trigger.getByday());
            paramMap.put("monthly", trigger.getMonthly());
            paramMap.put("bymonthday", trigger.getBymonthday());
            paramMap.put("byWeeklyday", trigger.getByweeklyday());
            paramMap.put("r_rule", trigger.getRRule());
        }
        return paramMap;
    }

    private void saveScheduleDefine(String tenantId, String ruleId, String actionId, String scheduleId, String trigger, String caller, int valid) {
        ScheduleDetailModel model = new ScheduleDetailModel(scheduleId, ruleId, tenantId, actionId, trigger, caller, valid);
        this.defineService.saveScheduleDefine(model);
    }
}

