package com.digiwin.athena.schedulemanager.core.constant;

/**
 * 排程常量定义
 *
 * @author: zhangww
 * @time: 2020/4/21 13:07
 */
public final class ScheduleConstant {

    /** 条件判断 */
    public static final int START_POS = 0;

    /** 排程频次类型 1指定时间 2周期性执行 3复杂周期性 4重复执行 */
    public static final int ASSIGN_TIME = 1;
    public static final int PERIOD = 2;
    public static final int COMPLEX_PERIOD = 3;
    public static final int REPEAT = 4;

    /** 排程处理状态：1成功 0失败 */
    public static final int SUCCESS = 1;
    public static final int FAIL = 0;

    /** 排程定义状态：1有效 0失效  */
    public static final int VALID = 1;
    public static final int INVALID = 0;

    /** 排程来源 EXECUTIONENGINE执行引擎 DATAMONITOR侦测引擎 THEMEMAP知识图谱 */
    public static final String MONITORENGINE = "MonitorEngine";

    /** 日志操作类型  1新增  2更新  3停止  4删除  5启用  */
    public static final int CREATE = 1;
    public static final int UPDATE = 2;
    public static final int STOP = 3;
    public static final int DELETE = 4;
    public static final int START = 5;

    /** 排程启动状态 Y/N */
    public static final String ENABLE = "Y";
    public static final String DISABLE = "N";

    /** appName,和配置里的OtherDapUrl关联，需要同步修改 */
    public static final String DWSYS = "DWSys";

    /** 集合初始化值 */
    public static final int CAPACITY_1 = 1;
    public static final int CAPACITY_16 = 16;
    public static final int CAPACITY_4 = 4;
    public static final int CAPACITY_8 = 8;

    /*********************  排程相关字段定义开始  ************/
    /** 执行job的接口名称 */
    public static final String JOB_NAME = "job_name";
    public static final String SCHEDULE_ADD = "addSchedules";
    public static final String SCHEDULE_UPDATE_EXCLUDE = "updateScheduleExcludeEnableStatus";
    public static final String SCHEDULE_UPDATE = "updateSchedule";
    public static final String SCHEDULE_REMOVE = "removeSchedule";
    public static final String SCHEDULE_ENABLE = "enableSchedule";
    public static final String SCHEDULE_DISABLE = "disableSchedule";
    public static final String SCHEDULE_GETINFO = "getScheduleInfos";
    public static final String SCHEDULE_REMOVE_CROSS = "removeScheduleCrossTenant";
    public static final String SCHEDULE_SERVICENAME = "IScheduleService";

    /** 方法参数设置常量 */
    public static final String SCHEDULEIDLIST = "scheduleIdList";
    public static final String SCHEDULE_IDS = "scheduleIds";

    /** 是否启用排程 */
    public static final String ENABLE_STATUS = "enable_status";

    /** 模组名称 */
    public static final String MODULE_NAME = "module_name";

    /**  排程编号 */
    public static final String SCHEDULE_ID = "schedule_id";

    /** 租户id */
    public static final String TENANTID = "tenantId";

    /** 用户id */
    public static final String USER_ID = "userId";

    /** 问句 */
    public static final String QUESTION = "question";

    /** 租户名称*/
    public static final String TENANTNAME = "tenantName";


    /**
     * 租户sid 字段名称；是tenantSid依據tenantid產生的流水識別碼
     */
    public static final String TENANT_SID = "tenantSid";

    /** 规则id */
    public static final String RULEID = "ruleId";

    public static final String MESSAGE_ID = "messageId";

    /** job执行传参 */
    public static final String SCHEDULE_PARAM = "schedule_param";

    public static final String SCHEDULE_CUSTOM_PARAM = "scheduleParam";

    /** 常用传参 */
    public static final String PARAMMAP = "paramMap";
    public static final String PARAM = "param";

    /** 排程job服务名称 */
    public static final String ISCHEDULEJOBSERVICE = "IExecuteService";

    /** 模组名称 */
    public static final String SCHEDULEMANAGER = "ScheduleManager";

    /** 响应状态 */
    public static final String STATUS = "status";
    public static final String DATA = "data";
    public static final String DATA_LIST = "dataList";

    /** 数据库相关 */
    public static final String INSTANCE_ID = "instance_id";
    public static final String CALLER = "caller";

    /** 排程规则设置 */
    public static final String SCHEDULE_TYPE = "schedule_type";
    public static final String ASSIGN_TIME_FIELD = "assign_time";
    public static final String MONTH = "month";
    public static final String WEEK_OF_MONTH = "week_of_month";
    public static final String DAY_OF_WEEK = "day_of_week";
    public static final String DAY_OF_MONTH = "day_of_month";
    public static final String TIME = "time";
    public static final String TIME1 = "time1";
    public static final String TIME2 = "time2";
    public static final String TIME3 = "time3";
    public static final String START_TIME = "start_time";
    public static final String END_TIME = "end_time";
    public static final String REPEAT_TYPE = "repeat_type";
    public static final String REPEAT_COUNT = "repeat_count";
    public static final String FREQUENCY = "frequency";
    public static final String MINUTELY = "minutely";
    public static final String HOURLY = "hourly";
    public static final String DAILY = "daily";
    public static final String WEEKLY = "weekly";
    public static final String BYDAY = "byday";
    public static final String MONTHLY = "monthly";
    public static final String BYMONTHDAY = "bymonthday";
    public static final String BYWEEKLYDAY = "byWeeklyday";
    public static final String R_RULE = "r_rule";

    /** HTTP相关 */
    public static final int HTTP_RESPONSE_SUCCESS_STATUS = 200;
}
