package com.digiwin.athena.schedulemanager.pojo.request;

import com.digiwin.athena.schedulemanager.constant.MessageConstant;
import com.digiwin.athena.schedulemanager.util.JsonUtil;

import javax.validation.constraints.NotEmpty;

/**
 * @description: 排程操作基础信息
 * @author: zhangww
 * @time: 2020/4/20 16:03
 */
public class ScheduleReq {

    /**
     * 租户id
     */
    @NotEmpty(message = MessageConstant.INVALID_TENANT, groups = {BatchScheduleReq.class})
    private String tenantId;

    /**
     * 规则列表
     */
    @NotEmpty(message = MessageConstant.INVALID_TRIGGER)
    private String ruleId;

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}
