package com.digiwin.athena.schedulemanager.provider;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.schedulemanager.core.aop.MyExceptionHandler;
import com.digiwin.athena.schedulemanager.core.aop.RouterKey;
import com.digiwin.athena.schedulemanager.core.message.ErrorCode;
import com.digiwin.athena.schedulemanager.pojo.request.OpsScheduleReq;
import com.digiwin.athena.schedulemanager.service.facade.IOpsFacadeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * @description: 排程服务运维接口实现
 * @author: zhangww
 * @time: 2020/4/13 09:48
 */
@Service("scheduleDevOpsService")
@MyExceptionHandler
public class DevOpsService implements IDevOpsService {

    private static final Logger LOGGER = LoggerFactory.getLogger(DevOpsService.class);

    private IOpsFacadeService service;

    public DevOpsService(IOpsFacadeService service) {
        this.service = service;
    }

    @Override
    @RouterKey
    public void clearDirtyData(OpsScheduleReq rule) {
        LOGGER.info("侦测引擎调用删除无效的排程：{}", rule);
        if (null == rule) {
            throw new DWRuntimeException(ErrorCode.PARAM_RULE_EMPTY_CODE.getCode(), ErrorCode.PARAM_RULE_EMPTY_CODE.getMessage());
        }
        service.deleteInvalidSchedule(rule);
    }
}
