package com.digiwin.athena.schedulemanager.provider;

import com.digiwin.app.schedule.entity.DWJobResult;
import com.digiwin.app.schedule.quartz.job.DWJob;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;

import java.util.Map;

/**
 * @description: 排程对外job服务
 * @author: zhangww
 * @time: 2020/4/16 11:49
 */
public interface IExecuteService extends DWService, DWJob {

    /**
     * 排程调用远程服务的对外接口
     * @param paramMap
     * @return
     * @throws Exception
     */
    DWJobResult post(Map<String, Object> paramMap);

    /**
     * 远程回调排程job
     * @param param
     * @return
     */
    @AllowAnonymous
    DWJobResult postExecuteRemoteJob(Map<String, Object> param);
}
