package com.digiwin.athena.schedulemanager.provider;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.schedulemanager.core.aop.MyExceptionHandler;
import com.digiwin.athena.schedulemanager.core.aop.RouterKey;
import com.digiwin.athena.schedulemanager.pojo.request.BatchScheduleReq;
import com.digiwin.athena.schedulemanager.pojo.request.ScheduleReq;
import com.digiwin.athena.schedulemanager.pojo.request.ScheduleUpdateReq;
import com.digiwin.athena.schedulemanager.service.facade.IScheduleFacadeService;
import com.digiwin.athena.schedulemanager.service.srp.impl.TenantService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * @author zhangww
 * @description: 排程操作调用接口实现
 * @date 2022/4/25 16:34
 */
@Service("ScheduleOpsProvider")
@MyExceptionHandler
public class ScheduleOpsProvider implements IScheduleOpsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduleOpsProvider.class);

    private IScheduleFacadeService service;
    private TenantService tenantService;
    public ScheduleOpsProvider(IScheduleFacadeService service, TenantService tenantService) {
        this.service = service;
        this.tenantService = tenantService;
    }

    @Override
    public void create(BatchScheduleReq rule) {
        LOGGER.info("侦测引擎调用创建排程：{}", rule);
        initContext(rule.getTenantId());
        service.createSchedule(rule);
    }

    @Override
    @RouterKey
    public void delete(ScheduleReq rule) {
        LOGGER.info("侦测引擎调用删除排程：{}", rule);
        service.deleteSchedule(rule);
    }

    @Override
    @RouterKey
    public JSONObject getSchedule(ScheduleReq rule) {
        LOGGER.info("侦测引擎调用查询排程：{}", rule);
        return service.getSchedule(rule);
    }

    @Override
    @RouterKey
    public void edit(ScheduleUpdateReq rule) {
        LOGGER.info("侦测引擎调用更新排程：{}", rule);
        service.updateSchedule(rule, rule.getEnableStatus());
    }

    @Override
    @RouterKey
    public void stop(ScheduleReq rule) {
        LOGGER.info("侦测引擎调用停用排程：{}", rule);
        service.stopSchedule(rule);
    }

    @Override
    @RouterKey
    public void start(ScheduleReq rule) {
        LOGGER.info("侦测引擎调用启用排程：{}", rule);
        initContext(rule.getTenantId());
        service.startSchedule(rule);
    }

    /**
     * 获取租户tenantSid，调用dao方法的时候需要校验上下文tenantSid
     * @param tenantId
     */
    private void initContext(String tenantId) {
        DWServiceContext.getContext().setProfile(tenantService.getProfile(tenantId));
    }
}