/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.schedulemanager.core.config;

import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.client.RestTemplate;

@EnableRetry
@Configuration(value="scheduleRestTemplateConfig")
@EnableAsync(proxyTargetClass=true)
public class RestTemplateConfig {
    @Value(value="${schedule.httpClientMaxTotal}")
    private int maxTotal;
    @Value(value="${schedule.httpClientMaxPerRoute}")
    private int maxPerRoute;
    @Value(value="${schedule.httpClientRequestTimeOutMilliSecond}")
    private int requestTimeOutMilliSecond;
    @Value(value="${schedule.httpClientConnectTimeOutMilliSecond}")
    private int connectTimeOutMilliSecond;
    @Value(value="${schedule.httpClientSocketTimeOutMilliSecond}")
    private int socketTimeOutMilliSecond;
    @Autowired(required=false)
    @Qualifier(value="dwAttemptHttpLoadbalanceRoute")
    HttpRoutePlanner httpRoutePlanner;

    @Bean(value={"schedule-sm-resttemplate"})
    public RestTemplate restTemplate(@Qualifier(value="schedule-sm-resttemplate-requestfactory") ClientHttpRequestFactory httpRequestFactory) {
        RestTemplate restTemplate = new RestTemplate(httpRequestFactory);
        return restTemplate;
    }

    @Bean(value={"schedule-httpClientConnectionManager"})
    public PoolingHttpClientConnectionManager getConnectionManager() {
        return new PoolingHttpClientConnectionManager();
    }

    @Bean(value={"schedule-sm-resttemplate-requestfactory"})
    public ClientHttpRequestFactory httpRequestFactory(@Qualifier(value="dw-httpclient-request-retry-handler") HttpRequestRetryHandler requestRetryHandler, @Qualifier(value="dw-httpclient-response-retry-strategy") ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        HttpClientBuilder builder = HttpClientBuilder.create().setRetryHandler(requestRetryHandler).setServiceUnavailableRetryStrategy(serviceUnavailableRetryStrategy);
        PoolingHttpClientConnectionManager connectionManager = this.getConnectionManager();
        connectionManager.setMaxTotal(this.maxTotal);
        connectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeOutMilliSecond).setConnectTimeout(this.connectTimeOutMilliSecond).setConnectionRequestTimeout(this.requestTimeOutMilliSecond).build();
        builder.setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).setRoutePlanner(this.httpRoutePlanner).build();
        CloseableHttpClient httpClient = builder.build();
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        return clientHttpRequestFactory;
    }
}

