package com.digiwin.athena.schedulemanager.core.aop;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.schedulemanager.core.constant.FieldNameConstant;
import com.digiwin.athena.schedulemanager.core.message.ErrorCode;
import com.digiwin.athena.schedulemanager.core.util.StringUtil;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.stereotype.Component;

/**
 * @author zhangww
 * @description: 参数RouterKey校验切面类
 * @date 2021/5/31 14:58
 */
@Aspect
@Component("sheduleRouterKeyAspect")
@EnableAspectJAutoProxy
public class RouterKeyAspect {

    /**
     * 参数routerKey统一校验
     *
     * @param routerKeyAnnotation
     * @return
     */
    @Before("@annotation(routerKeyAnnotation)")
    public void valid(RouterKey routerKeyAnnotation) {
        /** 验证routerKey **/
		String routerKey = (String) DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.ROUTER_KEY);
        if (StringUtil.isBlank(routerKey)) {
            throw new DWRuntimeException(ErrorCode.PARAM_ROUTER_KEY_EMPTY_CODE.getCode(), ErrorCode.PARAM_ROUTER_KEY_EMPTY_CODE.getMessage());
        }
    }
}