package com.digiwin.athena.schedulemanager.core.base;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.athena.schedulemanager.core.util.CollectionUtil;
import com.digiwin.athena.schedulemanager.util.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description: dao父类
 * @author: zhangww
 * @date: 2021/6/3 09:43
 */
public abstract class ScheduleBaseDao {

    @Autowired
    @Qualifier("schedule-dao")
    private DWDao dao;

    protected int update(String statement, Object... params) {
        return dao.update(statement, params);
    }

    protected int insert(String statement, Object... params) {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        return dao.update(option, statement, params);
    }

    protected List<Map<String, Object>> select(String statement, Object... params) {
        return dao.select(statement, params);
    }

    protected <T> List<T> select(Class<T> cls, String statement, Object... params) {
        List<Map<String, Object>> resultLit = select(statement, params);
        if (CollectionUtil.isEmpty(resultLit)) {
            return new ArrayList<>();
        }

        return resultLit.stream().map(JsonUtil::getJsonString)
                .map(itemStr -> JsonUtil.getObject(itemStr, cls))
                .collect(Collectors.toList());
    }
}
