package com.digiwin.athena.schedulemanager.core.config;

import org.apache.http.conn.HttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

/**
 * @author zhangww
 * @description:
 * @date 2023/7/19 15:40
 */
@Service("scheduleHttpConnectionCloseCron")
public class HttpConnectionCloseCron {

    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConnectionCloseCron.class);

    private final HttpClientConnectionManager httpClientConnectionManager;

    public HttpConnectionCloseCron(HttpClientConnectionManager httpClientConnectionManager) {
        this.httpClientConnectionManager = httpClientConnectionManager;
    }

    /**
     * 每5分钟检查一遍
     */
    @Scheduled(cron = "0 0/5 * * * ?")
    public void execute() {
        LOGGER.info("close http pool expire and idle connection...");
        // 关闭失效连接
        httpClientConnectionManager.closeExpiredConnections();
        // 空转连接30s后关闭
        httpClientConnectionManager.closeIdleConnections(30, TimeUnit.SECONDS);
    }
}