package com.digiwin.athena.schedulemanager.core.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author zhangww
 * @description: 消息交换机队列等配置
 * @date 2021/6/8 9:22
 */
@Component("scheduleRabbitMQProperty")
public class RabbitMQProperty {
    @Value("${spring.rabbitmq.host}")
    private String host;

    @Value("${spring.rabbitmq.port}")
    private int port;

    @Value("${spring.rabbitmq.username}")
    private String username;

    @Value("${spring.rabbitmq.password}")
    private String password;

    @Value("${spring.rabbitmq.virtual-host}")
    private String virtualHost;

    @Value("${schedule.rabbit.agile.exchange}")
    private String exchangeAgile;

    /**
     * 消息交换机的名字
     */
    @Value("${schedule.rabbit.monitor.exchange}")
    private String exchange;

    /**
     * 消息队列的名字
     */
    @Value("${schedule.rabbit.monitor.queue}")
    private String queue;

    /**
     * 消息队列的名字
     */
    @Value("${schedule.rabbit.ptm.queue}")
    private String queuePtm;

    /**
     * 消息队列的名字
     */
    @Value("${schedule.rabbit.taskengine.queue}")
    private String queueTaskEngine;

    /**
     * 消息队列的名字
     */
    @Value("${schedule.rabbit.workflow.queue}")
    private String queueWorkflow;

    /**
     * 路由键
     */
    @Value("${schedule.rabbit.monitor.routingKey}")
    private String routingKey;

    /**
     * 路由键
     */
    @Value("${schedule.rabbit.ptm.routingKey}")
    private String routingKeyPtm;

    /**
     * 路由键
     */
    @Value("${schedule.rabbit.taskengine.routingKey}")
    private String routingKeyTaskEngine;

    /**
     * 路由键
     */
    @Value("${schedule.rabbit.agile.routingKey}")
    private String routingKeyAgile;

    /**
     * 路由键
     */
    @Value("${schedule.rabbit.workflow.routingKey}")
    private String routingKeyWorkflow;

    /**
     * 死信消息交换机的名字
     */
    @Value("${schedule.rabbit.monitor.ddl.exchange}")
    private String ddlExchange;

    /**
     * 死信消息队列的名字
     */
    @Value("${schedule.rabbit.monitor.ddl.queue}")
    private String ddlQueue;

    /**
     * 死信路由键
     */
    @Value("${schedule.rabbit.monitor.ddl.routingKey}")
    private String ddlRoutingKey;

    /**
     * 消息过期时间
     */
    @Value("${schedule.rabbit.monitor.queue.ttl}")
    private int ttl;

    public String getExchange() {
        return exchange;
    }

    public String getVirtualHost() {
        return virtualHost;
    }

    public String getRoutingKey() {
        return routingKey;
    }

    public String getRoutingKeyAgile() {
        return routingKeyAgile;
    }

    public void setRoutingKeyAgile(String routingKeyAgile) {
        this.routingKeyAgile = routingKeyAgile;
    }

    public int getTtl() {
        return ttl;
    }

    public String getQueue() {
        return queue;
    }

    public String getQueuePtm() {
        return queuePtm;
    }

    public void setQueuePtm(String queuePtm) {
        this.queuePtm = queuePtm;
    }

    public String getRoutingKeyPtm() {
        return routingKeyPtm;
    }

    public void setRoutingKeyPtm(String routingKeyPtm) {
        this.routingKeyPtm = routingKeyPtm;
    }

    public String getQueueTaskEngine() {
        return queueTaskEngine;
    }

    public void setQueueTaskEngine(String queueTaskEngine) {
        this.queueTaskEngine = queueTaskEngine;
    }

    public String getRoutingKeyTaskEngine() {
        return routingKeyTaskEngine;
    }

    public void setRoutingKeyTaskEngine(String routingKeyTaskEngine) {
        this.routingKeyTaskEngine = routingKeyTaskEngine;
    }

    public String getDdlExchange() {
        return ddlExchange;
    }

    public String getDdlQueue() {
        return ddlQueue;
    }

    public String getDdlRoutingKey() {
        return ddlRoutingKey;
    }


    public String getExchangeAgile() {
        return exchangeAgile;
    }

    public void setExchangeAgile(String exchangeAgile) {
        this.exchangeAgile = exchangeAgile;
    }

    public String getQueueWorkflow() {
        return queueWorkflow;
    }

    public RabbitMQProperty setQueueWorkflow(String queueWorkflow) {
        this.queueWorkflow = queueWorkflow;
        return this;
    }

    public String getRoutingKeyWorkflow() {
        return routingKeyWorkflow;
    }

    public RabbitMQProperty setRoutingKeyWorkflow(String routingKeyWorkflow) {
        this.routingKeyWorkflow = routingKeyWorkflow;
        return this;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}
