package com.digiwin.athena.schedulemanager.core.config;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class ScheduleDWDefaultDWDaoEnableCondition implements Condition {

  /**
   * 默認的 dw-dao 是否啟用
   *
   * @param environment 環境
   * @return 是或否
   */
  public static boolean isEnabled(Environment environment) {
    String scheduleEnabled = environment.getProperty("dbEnabled");
    boolean isDbUrlEmpty = isUrlEmpty(environment);
    // 兩個都啟用才符合
    return "true".equalsIgnoreCase(scheduleEnabled) && !isDbUrlEmpty;
  }

  /**
   * 新默認 dao 數據源的 url 是否為空
   *
   * @param environment 環境
   * @return 是或否
   */
  public static boolean isUrlEmpty(Environment environment) {
    //增加spring.datasource.schedule.url.host判斷
    String datasourceUrl = environment.getProperty("spring.datasource.schedule.url");
    String datasourceUrlHost = environment.getProperty("spring.datasource.schedule.url.host");
    return (datasourceUrl == null || datasourceUrl.trim().equals("")) && (datasourceUrlHost == null
        || datasourceUrlHost.trim().equals(""));
  }

  @Override
  public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {

    return isEnabled(context.getEnvironment());
  }
}