package com.digiwin.athena.schedulemanager.core.constant;

import com.digiwin.app.common.DWApplicationPropertiesUtils;

/**
 * @description: Module资源文件配置实体类对象
 * @author: renwm
 * @date: 2020/4/28 09:02
 */
public final class StaticConfig {

    private StaticConfig() {
    }

    /**
     * IAM 用户登录 路径配置
     */
    public static final String IAM_USERLOGINURL = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "schedule.iamUserLoginUrl");

    /**
     * ThemeMap 域名
     */
    public static final String THEMEMAP_DOMAIN_URL = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "schedule.themeMap.domain.url");

    /** 调用themeMap获取licenseKey */
    public static final String THEMEMAP_LICENSEKEY_URL = THEMEMAP_DOMAIN_URL + "/service/knowledgegraph/app/getLicenseKey";

    /** ThemeMap md5key值  */
    public static final String THEMEMAP_LICENSEKEY_MD5_KEY = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "schedule.themeMap.licenseKey.md5.key");
    /** ThemeMap request from  */
    public static final String THEMEMAP_LICENSEKEY_REQUEST_FROM = DWApplicationPropertiesUtils.getProperty(FieldNameConstant.APPLICATION_PROPERTIES_NAME, "schedule.themeMap.licenseKey.request.from");

}
