package com.digiwin.athena.schedulemanager.core.message;

/**
 * @author: zhangww
 * @date: 2022/1/6 14:54
 */
public enum ErrorCode {

    PARAM_RULE_EMPTY_CODE("P.SM.100.001", "参数rule为空"),
    PARAM_ROUTER_KEY_EMPTY_CODE("P.SM.100.002", "请求routerKey信息为空！"),
    PARAM_LICENSE_KEY_KEY_EMPTY_CODE("P.SM.100.003", "获取licenseKey返回为空，请查看！"),
    PARAM_KM_LICENSE_KEY_EMPTY_CODE("P.SM.100.004", "排程调用km获取LicenseKey异常，请查看！"),
    ERROR_SCHEDULE_CREATE_CODE("P.SM.500.001", "调用api创建排程失败！"),
    ERROR_SCHEDULE_HANDLE_CODE("P.SM.500.002", "操作排程失败！"),
    ERROR_SCHEDULE_DELETE_CODE("P.SM.500.003", "调用api删除排程失败！"),
    ERROR_LOGIN_CODE("P.SM.500.004", "获取租户登录信息异常"),
    UNKNOWN_EXCEPTION("P.SM.500.9999", "未知异常");

    ErrorCode(String code, String message) {
        this.code = code;
        this.message = message;
    }

    private String code;

    private String message;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
