package com.digiwin.athena.schedulemanager.pojo.request;

import com.digiwin.athena.schedulemanager.constant.MessageConstant;
import com.digiwin.athena.schedulemanager.util.JsonUtil;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @description: 批量规则
 * @author: zhangww
 * @time: 2020/4/20 16:03
 */
public class BatchScheduleReq {

    /**
     * 租户id
     */
    @NotEmpty(message = MessageConstant.INVALID_TENANT)
    private String tenantId;

    /**
     * 规则列表
     */
    @Valid
    @NotEmpty(message = MessageConstant.INVALID_TRIGGER)
    private List<ScheduleUpdateReq> ruleList;

    public List<ScheduleUpdateReq> getRuleList() {
        return ruleList;
    }

    public void setRuleList(List<ScheduleUpdateReq> ruleList) {
        this.ruleList = ruleList;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}
