package com.digiwin.athena.schedulemanager.pojo.request;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.schedulemanager.constant.MessageConstant;
import com.digiwin.athena.schedulemanager.util.JsonUtil;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @description: 排程修改规则
 * @author: zhangww
 * @time: 2020/4/20 16:03
 */
public class ScheduleUpdateReq extends ScheduleReq {

    /**
     * 动作id
     */
    private String actionId;

    private String enableStatus;

    /**
     *  定时任务的来源  默认MonitorEngine 侦测
     */
    private String caller;

    private JSONObject scheduleParam;

    @NotEmpty(message = MessageConstant.INVALID_TRIGGER)
    private List<TriggerReq> triggers;

    public String getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(String enableStatus) {
        this.enableStatus = enableStatus;
    }

    public String getActionId() {
        return actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public List<TriggerReq> getTriggers() {
        return triggers;
    }

    public void setTriggers(List<TriggerReq> triggers) {
        this.triggers = triggers;
    }

    public String getCaller() {
        return caller;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }

    public JSONObject getScheduleParam() {
        return scheduleParam;
    }

    public void setScheduleParam(JSONObject scheduleParam) {
        this.scheduleParam = scheduleParam;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}
