package com.digiwin.athena.schedulemanager.repository.dao.impl;

import com.digiwin.athena.schedulemanager.core.base.ScheduleBaseDao;
import com.digiwin.athena.schedulemanager.repository.dao.IScheduleLogDao;
import com.digiwin.athena.schedulemanager.repository.model.ScheduleLogModel;
import org.springframework.stereotype.Repository;

/**
 * @description: 排程操作记录
 * @author: zhangww
 * @time: 2020/4/16 14:27
 */
@Repository
public class ScheduleLogDaoSchedule extends ScheduleBaseDao implements IScheduleLogDao{

    @Override
    public void saveScheduleLog(ScheduleLogModel logModel) {
        String insert = "insert into sd_schedule_log (instance_id,createtime,updatetime,caller,calltype,remark) " +
                "values (?,?,?,?,?,?)";
        insert(insert, logModel.getInstanceId(), logModel.getCreateTime(), logModel.getUpdateTime(),
                logModel.getCaller(), logModel.getCallType(), logModel.getRemark());
    }
}
