package com.digiwin.athena.schedulemanager.service.facade.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.schedulemanager.core.constant.ScheduleConstant;
import com.digiwin.athena.schedulemanager.core.message.ErrorCode;
import com.digiwin.athena.schedulemanager.core.util.CollectionUtil;
import com.digiwin.athena.schedulemanager.pojo.request.OpsScheduleReq;
import com.digiwin.athena.schedulemanager.repository.model.ScheduleDetailModel;
import com.digiwin.athena.schedulemanager.service.client.IDwScheduleClient;
import com.digiwin.athena.schedulemanager.service.facade.IOpsFacadeService;
import com.digiwin.athena.schedulemanager.service.srp.IScheduleDefineService;
import com.digiwin.athena.schedulemanager.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @description: 排程引擎运维接口
 * @author: zhangww
 * @time: 2020/4/13 12:22
 */
@Service("scheduleOpsFacadeService")
public class OpsFacadeService implements IOpsFacadeService {

    private static final Logger LOGGER = LoggerFactory.getLogger(OpsFacadeService.class);

    private IScheduleDefineService defineService;

    private IDwScheduleClient dwScheduleClient;

    public OpsFacadeService(IScheduleDefineService defineService, IDwScheduleClient dwScheduleClient) {
        this.defineService = defineService;
        this.dwScheduleClient = dwScheduleClient;
    }

    /**
     * 删除排程(已经被置为无效，但还存在运行中的实例)
     * @param rule
     * @return
     */
    @Override
    public void deleteInvalidSchedule(OpsScheduleReq rule) {
        List<ScheduleDetailModel> details = defineService.getValidScheduleInfoByRuleId(rule.getRuleId());
        if (CollectionUtil.isEmpty(details)) {
            LOGGER.warn("通过条件{}查询，暂无匹配排程记录", rule);
            return;
        }
        List<String> scheduleIdList = details.stream().map(ScheduleDetailModel::getInstanceId).collect(Collectors.toList());
        //调用api删除排程
        String response = dwScheduleClient.executeQuartz(scheduleIdList, ScheduleConstant.SCHEDULE_REMOVE);
        JSONObject resultObj = JsonUtil.getObject(response);
        if (ScheduleConstant.HTTP_RESPONSE_SUCCESS_STATUS != resultObj.getIntValue(ScheduleConstant.STATUS)) {
            LOGGER.error("调用api删除排程失败！");
            throw new DWRuntimeException(ErrorCode.ERROR_SCHEDULE_DELETE_CODE.getCode(), ErrorCode.ERROR_SCHEDULE_DELETE_CODE.getMessage());
        }
    }
}