/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.schedulemanager.core.aop;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.container.exceptions.IDWException;
import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.athena.schedulemanager.core.message.ErrorCode;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component(value="sheduleExceptionHandlerAspect")
public class ExceptionHandlerAspect {
    public static final String CHAIN_INFO = "chainInfo";
    private static final String SUBSTRING = "trace info: me: ";
    public static final String PTX_ID = "PtxId";

    @Pointcut(value="@within(com.digiwin.athena.schedulemanager.core.aop.MyExceptionHandler)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        try {
            return proceedingJoinPoint.proceed();
        }
        catch (Exception e) {
            String chainInfo = DWServiceChainContext.getContext().getTraceElement().getTraceInfo(true);
            if (chainInfo.indexOf(SUBSTRING) != -1) {
                chainInfo = StringUtils.substringAfter((String)chainInfo, (String)SUBSTRING);
            }
            if (e instanceof IDWException) {
                IDWException exception = (IDWException)e;
                if (!exception.getInstructors().containsKey(CHAIN_INFO) || exception.getInstructors().get(CHAIN_INFO) == null) {
                    exception.getInstructors().put(CHAIN_INFO, chainInfo);
                }
                if (!exception.getInstructors().containsKey(PTX_ID) || exception.getInstructors().get(PTX_ID) == null) {
                    exception.getInstructors().put(PTX_ID, ThreadContext.get((String)PTX_ID));
                }
                throw e;
            }
            DWRuntimeException exception = new DWRuntimeException(ErrorCode.UNKNOWN_EXCEPTION.getCode(), ErrorCode.UNKNOWN_EXCEPTION.getMessage());
            exception.getInstructors().put(CHAIN_INFO, chainInfo);
            exception.getInstructors().put(PTX_ID, ThreadContext.get((String)PTX_ID));
            throw exception;
        }
    }
}

