/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.schedulemanager.core.config;

import com.digiwin.athena.schedulemanager.core.config.RabbitMQProperty;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="scheduleRabbitMQConfig")
public class RabbitMQConfig
implements RabbitTemplate.ConfirmCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMQConfig.class);
    @Autowired
    @Qualifier(value="scheduleRabbitMQProperty")
    private RabbitMQProperty rabbitMQProperty;

    @Bean(value={"scheduleConnectionFactory"})
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        connectionFactory.setHost(this.rabbitMQProperty.getHost());
        connectionFactory.setPort(this.rabbitMQProperty.getPort());
        connectionFactory.setUsername(this.rabbitMQProperty.getUsername());
        connectionFactory.setPassword(this.rabbitMQProperty.getPassword());
        connectionFactory.setVirtualHost(this.rabbitMQProperty.getVirtualHost());
        return connectionFactory;
    }

    @Bean(value={"scheduleRabbitAdmin"})
    public RabbitAdmin rabbitAdmin(@Qualifier(value="scheduleConnectionFactory") ConnectionFactory connectionFactory) {
        return new RabbitAdmin(connectionFactory);
    }

    @Bean(name={"scheduleRabbitTemplate"})
    public RabbitTemplate rabbitTemplate(@Qualifier(value="scheduleConnectionFactory") ConnectionFactory rabbitConnectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(rabbitConnectionFactory);
        rabbitTemplate.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        rabbitTemplate.setConfirmCallback((RabbitTemplate.ConfirmCallback)this);
        return rabbitTemplate;
    }

    @Bean(value={"scheduleGetDirectExchange"})
    public DirectExchange getDirectExchange() {
        return new DirectExchange(this.rabbitMQProperty.getExchange(), true, false, null);
    }

    @Bean(value={"scheduleGetQueue"})
    public Queue getQueue() {
        HashMap<String, Object> arguments = new HashMap<String, Object>(4);
        arguments.put("x-message-ttl", this.rabbitMQProperty.getTtl());
        arguments.put("x-dead-letter-exchange", this.rabbitMQProperty.getDdlExchange());
        arguments.put("x-dead-letter-routing-key", this.rabbitMQProperty.getDdlRoutingKey());
        return new Queue(this.rabbitMQProperty.getQueue(), true, false, false, arguments);
    }

    @Bean(value={"scheduleGetQueuePtm"})
    public Queue getQueuePtm() {
        HashMap<String, Integer> arguments = new HashMap<String, Integer>(4);
        arguments.put("x-message-ttl", this.rabbitMQProperty.getTtl());
        return new Queue(this.rabbitMQProperty.getQueuePtm(), true, false, false, arguments);
    }

    @Bean(value={"scheduleGetQueueTask"})
    public Queue getQueueTask() {
        HashMap<String, Integer> arguments = new HashMap<String, Integer>(4);
        arguments.put("x-message-ttl", this.rabbitMQProperty.getTtl());
        return new Queue(this.rabbitMQProperty.getQueueTaskEngine(), true, false, false, arguments);
    }

    @Bean(value={"scheduleGetQueueWorkflow"})
    public Queue getQueueWorkflow() {
        HashMap<String, Integer> arguments = new HashMap<String, Integer>(4);
        arguments.put("x-message-ttl", this.rabbitMQProperty.getTtl());
        return new Queue(this.rabbitMQProperty.getQueueWorkflow(), true, false, false, arguments);
    }

    @Bean(value={"scheduleBinding"})
    public Binding binding() {
        return BindingBuilder.bind((Queue)this.getQueue()).to(this.getDirectExchange()).with(this.rabbitMQProperty.getRoutingKey());
    }

    @Bean(value={"scheduleBindingPtm"})
    public Binding bindingPtm() {
        return BindingBuilder.bind((Queue)this.getQueuePtm()).to(this.getDirectExchange()).with(this.rabbitMQProperty.getRoutingKeyPtm());
    }

    @Bean(value={"scheduleBindingTask"})
    public Binding bindingTask() {
        return BindingBuilder.bind((Queue)this.getQueueTask()).to(this.getDirectExchange()).with(this.rabbitMQProperty.getRoutingKeyTaskEngine());
    }

    @Bean(value={"scheduleBindingWorkflow"})
    public Binding bindingWorkflow() {
        return BindingBuilder.bind((Queue)this.getQueueWorkflow()).to(this.getDirectExchange()).with(this.rabbitMQProperty.getRoutingKeyWorkflow());
    }

    @Bean(value={"scheduleGetDeadLetterDirectExchange"})
    public DirectExchange getDeadLetterDirectExchange() {
        return new DirectExchange(this.rabbitMQProperty.getDdlExchange(), true, false, null);
    }

    @Bean(value={"scheduleGetDeadLetterQueue"})
    public Queue getDeadLetterQueue() {
        return new Queue(this.rabbitMQProperty.getDdlQueue(), true, false, false);
    }

    @Bean(value={"scheduleBindingDeadLetter"})
    public Binding bindingDeadLetter() {
        return BindingBuilder.bind((Queue)this.getDeadLetterQueue()).to(this.getDeadLetterDirectExchange()).with(this.rabbitMQProperty.getDdlRoutingKey());
    }

    public void confirm(CorrelationData correlationData, boolean isAck, String cause) {
        if (!isAck) {
            LOGGER.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25,ID\u4e3a: {},\u9519\u8bef\u4fe1\u606f: {}", (Object)correlationData.getId(), (Object)cause);
        }
    }
}

