/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.schedulemanager.producer;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.schedulemanager.core.config.RabbitMQProperty;
import com.digiwin.athena.schedulemanager.core.util.AgileParamsAssemble;
import com.digiwin.athena.schedulemanager.core.util.StringUtil;
import com.digiwin.athena.schedulemanager.service.client.impl.CustomHttpClient;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="scheduleMessageProducer")
public class MessageProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProducer.class);
    public static final String ROUTING_KEY = "routingKey.schedule.execute";
    public static final String AGILE_CALLER = "agileSubscribe";
    @Autowired
    @Qualifier(value="scheduleRabbitTemplate")
    private RabbitTemplate template;
    @Autowired
    @Qualifier(value="scheduleRabbitMQProperty")
    private RabbitMQProperty rabbitMQProperty;
    @Autowired
    @Qualifier(value="scheduleCustomHttpClient")
    private CustomHttpClient customHttpClient;

    public String sendMessage(Map<String, Object> paramMap) {
        String routingKey;
        String messageId = UUID.randomUUID().toString();
        String string = routingKey = StringUtil.isEmpty(MapUtils.getString(paramMap, (Object)"caller")) ? this.rabbitMQProperty.getRoutingKey() : ROUTING_KEY + MapUtils.getString(paramMap, (Object)"caller");
        if (AGILE_CALLER.equals(MapUtils.getString(paramMap, (Object)"caller"))) {
            LOGGER.info("MessageProducer#sendMessage trigger send message :{}, exchangeAgile :{}, agileRoutingKey :{}, v-host :{}", new Object[]{paramMap, this.rabbitMQProperty.getExchangeAgile(), this.rabbitMQProperty.getRoutingKeyAgile(), this.rabbitMQProperty.getVirtualHost()});
            String tenantId = MapUtils.getString(paramMap, (Object)"tenantId");
            if (StringUtils.isBlank((CharSequence)tenantId)) {
                return "";
            }
            String realTimeTenantToken = this.customHttpClient.getRealTimeTenantToken(tenantId);
            MessageProperties messageProperties = new MessageProperties();
            messageProperties.setHeader("token", (Object)realTimeTenantToken);
            messageProperties.setHeader("routerKey", (Object)tenantId);
            Map<String, Object> resultMap = AgileParamsAssemble.assembleMqMesssage(MapUtils.getMap(paramMap, (Object)"scheduleParam"));
            Message message = new Message(JSONObject.toJSONString(resultMap).getBytes(), messageProperties);
            this.template.convertAndSend(this.rabbitMQProperty.getExchangeAgile(), this.rabbitMQProperty.getRoutingKeyAgile(), (Object)message, new CorrelationData(messageId));
        } else {
            this.template.convertAndSend(this.rabbitMQProperty.getExchange(), routingKey, paramMap, new CorrelationData(messageId));
        }
        return messageId;
    }
}

