/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.schedulemanager.repository.dao.impl;

import com.digiwin.athena.schedulemanager.core.base.ScheduleBaseDao;
import com.digiwin.athena.schedulemanager.repository.dao.IScheduleDefineDao;
import com.digiwin.athena.schedulemanager.repository.model.ScheduleDetailModel;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class ScheduleDefineDaoSchedule
extends ScheduleBaseDao
implements IScheduleDefineDao {
    @Override
    public void saveScheduleDefine(ScheduleDetailModel model) {
        String insert = "insert into sd_schedule_detail (rule_id,tenantid,instance_id,action_id,triggers,caller,valid -${tenantName}) values (?,?,?,?,?,?,? -${tenantValue})";
        this.update(insert, model.getRuleId(), model.getTenantId(), model.getInstanceId(), model.getActionId(), model.getTriggers(), model.getCaller(), model.getValid());
    }

    @Override
    public void deleteScheduleDefine(String instanceId) {
        String update = "update sd_schedule_detail set valid = ? where instance_id = ? -${tenantsid}";
        this.update(update, 0, instanceId);
    }

    @Override
    public int updateTrigger(String trigger, String instanceId) {
        String updateTrigger = "update sd_schedule_detail set triggers = ? where instance_id = ? -${tenantsid}";
        return this.update(updateTrigger, trigger, instanceId);
    }

    @Override
    public List<ScheduleDetailModel> getScheduleInfoByRuleId(String ruleId) {
        String getScheduleInfo = "select instance_id,triggers from sd_schedule_detail where rule_id = ? and valid = 1 -${tenantsid}";
        return this.select(ScheduleDetailModel.class, getScheduleInfo, ruleId);
    }

    @Override
    public List<ScheduleDetailModel> getValidScheduleInfoByRuleId(String ruleId) {
        String getScheduleInfo = "select instance_id from sd_schedule_detail where rule_id = ? and valid = 0 -${tenantsid}";
        return this.select(ScheduleDetailModel.class, getScheduleInfo, ruleId);
    }

    @Override
    public boolean isNotExist(String ruleId, String instanceId) {
        String getScheduleInfo = "select instance_id from sd_schedule_detail where rule_id = ? and instance_id = ? and valid = 1 -${tenantsid}";
        return this.select(ScheduleDetailModel.class, getScheduleInfo, ruleId, instanceId).isEmpty();
    }
}

