/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.schedulemanager.service.client.impl;

import com.digiwin.app.serviceclient.ServiceClient;
import com.digiwin.athena.schedulemanager.pojo.request.CrossReq;
import com.digiwin.athena.schedulemanager.service.client.IDwScheduleClient;
import com.digiwin.athena.schedulemanager.util.JsonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="scheduleDwScheduleClient")
public class DwScheduleClient
implements IDwScheduleClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DwScheduleClient.class);

    @Override
    public String addQuartz(List<Map<String, Object>> scheduleParamList, String methodName) {
        LOGGER.info("\u8bf7\u6c42\u53c2\u6570\u4e3a[{}],\u65b9\u6cd5\u4e3a[{}]\u8fdb\u884c\u6392\u7a0b\u5904\u7406", (Object)JsonUtil.getJsonString(scheduleParamList), (Object)methodName);
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("paramMap", scheduleParamList);
        String result = this.executeRemote(param, methodName);
        LOGGER.info("\u8c03\u7528\u6392\u7a0b\u7ed3\u679c\uff1a{}", (Object)result);
        return result;
    }

    @Override
    public String executeQuartz(List<String> scheduleIdList, String methodName) {
        LOGGER.info("\u8bf7\u6c42\u53c2\u6570\u4e3a[{}],\u65b9\u6cd5\u4e3a[{}]\u8fdb\u884c\u6392\u7a0b\u5904\u7406", (Object)JsonUtil.getJsonString(scheduleIdList), (Object)methodName);
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("scheduleIdList", scheduleIdList);
        String result = this.executeRemote(param, methodName);
        LOGGER.info("\u8c03\u7528\u6392\u7a0b\u7ed3\u679c\uff1a{}", (Object)result);
        return result;
    }

    @Override
    public String getQuartz(List<String> scheduleIdList) {
        LOGGER.info("\u8c03\u7528api\u67e5\u8be2\u6392\u7a0b\uff1a{}", scheduleIdList);
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("scheduleIds", scheduleIdList);
        String result = this.executeRemote(param, "getScheduleInfos");
        LOGGER.info("\u67e5\u8be2\u6392\u7a0b\u7ed3\u679c\uff1a{}", (Object)result);
        return result;
    }

    @Override
    public String deleteQuartzCross(CrossReq cross) {
        LOGGER.info("\u8c03\u7528api\u8de8\u79df\u6237\u5220\u9664\u6392\u7a0b\uff1a{}", (Object)cross);
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("paramMap", cross.getParamMap());
        String result = this.executeRemote(param, "removeScheduleCrossTenant");
        LOGGER.info("\u8c03\u7528api\u8de8\u79df\u6237\u5220\u9664\u6392\u7a0b\u7ed3\u679c\uff1a{}", (Object)result);
        return result;
    }

    private String executeRemote(Map<String, Object> param, String method) {
        return new ServiceClient().invokeThisDapService("DWSys", "IScheduleService", method, param);
    }
}

