/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.schedulemanager.service.facade.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.schedulemanager.core.message.ErrorCode;
import com.digiwin.athena.schedulemanager.core.util.CollectionUtil;
import com.digiwin.athena.schedulemanager.pojo.request.OpsScheduleReq;
import com.digiwin.athena.schedulemanager.repository.model.ScheduleDetailModel;
import com.digiwin.athena.schedulemanager.service.client.IDwScheduleClient;
import com.digiwin.athena.schedulemanager.service.facade.IOpsFacadeService;
import com.digiwin.athena.schedulemanager.service.srp.IScheduleDefineService;
import com.digiwin.athena.schedulemanager.util.JsonUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="scheduleOpsFacadeService")
public class OpsFacadeService
implements IOpsFacadeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpsFacadeService.class);
    private IScheduleDefineService defineService;
    private IDwScheduleClient dwScheduleClient;

    public OpsFacadeService(IScheduleDefineService defineService, IDwScheduleClient dwScheduleClient) {
        this.defineService = defineService;
        this.dwScheduleClient = dwScheduleClient;
    }

    @Override
    public void deleteInvalidSchedule(OpsScheduleReq rule) {
        List<ScheduleDetailModel> details = this.defineService.getValidScheduleInfoByRuleId(rule.getRuleId());
        if (CollectionUtil.isEmpty(details)) {
            LOGGER.warn("\u901a\u8fc7\u6761\u4ef6{}\u67e5\u8be2\uff0c\u6682\u65e0\u5339\u914d\u6392\u7a0b\u8bb0\u5f55", (Object)rule);
            return;
        }
        List<String> scheduleIdList = details.stream().map(ScheduleDetailModel::getInstanceId).collect(Collectors.toList());
        String response = this.dwScheduleClient.executeQuartz(scheduleIdList, "removeSchedule");
        JSONObject resultObj = JsonUtil.getObject(response);
        if (200 != resultObj.getIntValue("status")) {
            LOGGER.error("\u8c03\u7528api\u5220\u9664\u6392\u7a0b\u5931\u8d25\uff01");
            throw new DWRuntimeException(ErrorCode.ERROR_SCHEDULE_DELETE_CODE.getCode(), ErrorCode.ERROR_SCHEDULE_DELETE_CODE.getMessage());
        }
    }
}

