/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.schedulemanager.service.srp.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.athena.schedulemanager.core.constant.StaticConfig;
import com.digiwin.athena.schedulemanager.core.exception.BusinessException;
import com.digiwin.athena.schedulemanager.core.message.ErrorCode;
import com.digiwin.athena.schedulemanager.core.util.CollectionUtil;
import com.digiwin.athena.schedulemanager.core.util.SecurityUtil;
import com.digiwin.athena.schedulemanager.core.util.StringUtil;
import com.digiwin.athena.schedulemanager.service.client.impl.CustomHttpClient;
import com.digiwin.athena.schedulemanager.util.JsonUtil;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service(value="scheduleTenantService")
public class TenantService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantService.class);
    @Autowired
    @Qualifier(value="scheduleCustomHttpClient")
    private CustomHttpClient httpClient;
    public static final String LICENSEKEY_REQUEST_FROM = "requestFrom";
    public static final String LICENSEKEY_TIMESTAMP = "timestamp";
    public static final String LICENSEKEY_KEY = "key";
    private static final String PASSWORD_HASH = DWApplicationConfigUtils.getProperty((String)"schedule.IamClient.PASSWORD_HASH");

    private String getUserTenantSid(String tenantId) {
        Map<String, Object> iamResult = this.identityLogin(tenantId);
        return MapUtils.getString(iamResult, (Object)"tenantSid");
    }

    private Map<String, Object> identityLogin(String tenantId) {
        HttpResponseModel responseModel;
        HashMap<String, String> paramMap = new HashMap<String, String>(4);
        paramMap.put("tenantId", tenantId);
        paramMap.put("identityType", "internal");
        paramMap.put("userId", "integration");
        paramMap.put(this.getMapKey(), PASSWORD_HASH);
        ServiceModel iamModel = new ServiceModel();
        iamModel.setInvokeURL(StaticConfig.IAM_USERLOGINURL);
        iamModel.setParams(paramMap);
        iamModel.setRequestMethod(DWRequestMethod.POST);
        try {
            responseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)iamModel);
            LOGGER.info("\u83b7\u53d6\u79df\u6237\u767b\u5f55\u4fe1\u606f = {}", (Object)responseModel);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u79df\u6237\u767b\u5f55\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new DWRuntimeException(ErrorCode.ERROR_LOGIN_CODE.getCode(), ErrorCode.ERROR_LOGIN_CODE.getMessage());
        }
        if (200 == responseModel.getHttpStatusCode()) {
            return JSONObject.parseObject((String)responseModel.getResponseBody());
        }
        return null;
    }

    private String getMapKey() {
        return "passwordHash";
    }

    private Map<String, Object> licenseKeyParam(String tenantId) {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        long timestamp = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        String key = SecurityUtil.getMd5Hex(sb.append(tenantId).append(StaticConfig.THEMEMAP_LICENSEKEY_REQUEST_FROM).append(timestamp).append(StaticConfig.THEMEMAP_LICENSEKEY_MD5_KEY).toString());
        param.put("tenantId", tenantId);
        param.put(LICENSEKEY_REQUEST_FROM, StaticConfig.THEMEMAP_LICENSEKEY_REQUEST_FROM);
        param.put(LICENSEKEY_TIMESTAMP, timestamp);
        param.put(LICENSEKEY_KEY, key);
        return param;
    }

    private String getTenantSecretKey(String tenantId) {
        Map<String, Object> licenseKeyParam = this.licenseKeyParam(tenantId);
        String httpResp = this.httpClient.doPost(StaticConfig.THEMEMAP_LICENSEKEY_URL, licenseKeyParam, DWServiceContext.getContext().getToken(), tenantId);
        JSONObject httpRespOjb = JsonUtil.getObject(httpResp);
        if (CollectionUtil.isNotEmpty((Map)httpRespOjb) && 200 == httpRespOjb.getIntValue("status")) {
            LOGGER.info("\u6392\u7a0b\u8c03\u7528km\u83b7\u53d6LicenseKey\u6210\u529f\uff01");
            String data = httpRespOjb.getString("response");
            if (StringUtil.isEmpty(data)) {
                throw new BusinessException(ErrorCode.PARAM_LICENSE_KEY_KEY_EMPTY_CODE);
            }
            return SecurityUtil.decodeAES(data);
        }
        LOGGER.error("\u6392\u7a0b\u8c03\u7528ThemeMap\u83b7\u53d6LicenseKey\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a[{}]", (Object)httpRespOjb);
        throw new BusinessException(ErrorCode.PARAM_KM_LICENSE_KEY_EMPTY_CODE);
    }

    @Retryable(value={DWRuntimeException.class}, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Map<String, Object> getProfile(String tenantId) {
        HashMap<String, Object> profileMap = new HashMap<String, Object>(1);
        String tenantSid = this.getUserTenantSid(tenantId);
        if (StringUtil.isNotBlank(tenantSid)) {
            profileMap.put("tenantSid", Long.parseLong(tenantSid));
        }
        return profileMap;
    }
}

