/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.schedulemanager.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.List;
import java.util.Map;

public final class JsonUtil {
    private JsonUtil() {
    }

    public static <T> T getObject(String jsonText, Class<T> clazz) {
        return (T)JSON.parseObject((String)jsonText, clazz);
    }

    public static JSONObject getObject(String jsonText) {
        return JSON.parseObject((String)jsonText);
    }

    public static <T> T parseObject(String text, TypeReference<T> type) {
        return (T)JSON.parseObject((String)text, type, (Feature[])new Feature[0]);
    }

    public static <T> T getObjectByKey(String data, String key, Class<T> cls) {
        return (T)JsonUtil.getObject(data, JSONObject.class).getObject(key, cls);
    }

    public static String getJsonString(Object object) {
        return JSON.toJSONString((Object)object);
    }

    public static String getJsonString(Object object, SerializerFeature feature) {
        return JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{feature});
    }

    public static <T> List<T> getList(String jsonStr, Class<T> clazz) {
        return JSON.parseArray((String)jsonStr, clazz);
    }

    public static JSONArray getList(String jsonStr) {
        return JSON.parseArray((String)jsonStr);
    }

    public static <T> List<T> getListByKey(String data, String key, Class<T> cls) {
        return JsonUtil.getObject(data, JSONObject.class).getJSONArray(key).toJavaList(cls);
    }

    public static <T> List<T> getListByKey(JSONObject data, String key, Class<T> cls) {
        return data.getJSONArray(key).toJavaList(cls);
    }

    public static Map<String, Object> json2Map(String jsonStr) {
        return (Map)JSON.parseObject((String)jsonStr, Map.class);
    }
}

