/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.trans.components.CalculateStep;
import com.digiwin.athena.executionengine.trans.pojo.element.DealResult;
import com.digiwin.athena.executionengine.trans.pojo.element.Statistic;
import com.digiwin.athena.executionengine.trans.pojo.element.StepElement;
import com.digiwin.athena.executionengine.trans.util.RegexUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.BrentSolver;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component(value="group")
public class GroupStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupStep.class);
    private static Map<String, BiConsumer<Statistic, Map<Map, List<Map<String, Object>>>>> FUNCTION_MAP = new HashMap<String, BiConsumer<Statistic, Map<Map, List<Map<String, Object>>>>>();

    @Override
    public boolean defineCheck(StepElement stepElement) {
        return true;
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        try {
            Object inputData = this.getCurrentData(step.getPrevStepNameList());
            if (!(inputData instanceof List)) {
                LOGGER.warn("\u5206\u7ec4\u7ec4\u4ef6\u53ea\u80fd\u63a5\u53d7\u8868\u72b6\u6570\u636e\uff0c\u975e\u5c55\u5e73\u6570\u636e\u9700\u8981\u5148\u6267\u884c\u5c55\u5e73\u8282\u70b9\uff01Trans\u6267\u884c {} \u5931\u8d25\uff0c\u6570\u636e\u7ed3\u6784\u9519\u8bef\uff01", (Object)step.getName());
                dealResult.setDataNullFail();
                return dealResult;
            }
            List dataList = (List)inputData;
            if (CollectionUtils.isEmpty(dataList)) {
                dealResult.setSuccess(Lists.newArrayList());
                return dealResult;
            }
            StepElement stepElement = step.getStepElement();
            List<String> fieldList = CollectionUtils.isNotEmpty(stepElement.getFields()) ? stepElement.getFields() : new ArrayList<String>();
            Map<Map, List<Map<String, Object>>> resultMap = dataList.stream().collect(Collectors.groupingBy(map -> {
                HashMap<String, String> fieldMap = new HashMap<String, String>();
                for (String field : fieldList) {
                    fieldMap.put(field, String.valueOf(map.get(field)));
                }
                return fieldMap;
            }));
            List<Statistic> statisticList = stepElement.getStatistics();
            if (CollectionUtils.isNotEmpty(statisticList)) {
                List<Statistic> sortStatistics = statisticList.stream().filter(statistic -> statistic.getStatisticalMethod().equals("sort")).collect(Collectors.toList());
                List otherStatistics = statisticList.stream().filter(statistic -> !statistic.getStatisticalMethod().equals("sort")).collect(Collectors.toList());
                Map<Map, List<Map<String, Object>>> sortMap = this.doGroupSort(fieldList, sortStatistics, resultMap);
                for (Statistic statistic2 : otherStatistics) {
                    this.doCalculate(statistic2, sortMap);
                }
                ArrayList<Map> resultList = new ArrayList<Map>();
                if ("sql".equalsIgnoreCase(this.getTransDataManager().getMode())) {
                    for (Map.Entry<Map, List<Map<String, Object>>> entry : sortMap.entrySet()) {
                        Map dataMap = entry.getKey();
                        dataMap.putAll(entry.getValue().get(0));
                        resultList.add(dataMap);
                    }
                } else {
                    for (Map.Entry<Map, List<Map<String, Object>>> entry : sortMap.entrySet()) {
                        resultList.addAll((Collection)entry.getValue());
                    }
                }
                dealResult.setSuccess(resultList);
                return dealResult;
            }
            dealResult.setSuccess(new ArrayList());
            return dealResult;
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u5206\u7ec4\u7ec4\u4ef6\u51fa\u73b0\u5f02\u5e38");
            throw e;
        }
    }

    private Map<Map, List<Map<String, Object>>> doGroupSort(List<String> fieldList, List<Statistic> sortStatistics, Map<Map, List<Map<String, Object>>> resultMap) {
        boolean bl;
        HashSet<String> fieldListSet = new HashSet<String>(fieldList);
        List<Statistic> groupSortStatistics = sortStatistics.stream().filter(statistic -> fieldListSet.contains(statistic.getStatisticalFields().get(0))).collect(Collectors.toList());
        LinkedHashMap<Map, List<Map<String, Object>>> sortedMap = new LinkedHashMap<Map, List<Map<String, Object>>>();
        if (CollectionUtils.isNotEmpty(groupSortStatistics)) {
            ArrayList<Map.Entry<Map, List<Map<String, Object>>>> entries = new ArrayList<Map.Entry<Map, List<Map<String, Object>>>>(resultMap.entrySet());
            entries.sort(this.createGroupComparator(groupSortStatistics));
            for (Map.Entry entry : entries) {
                sortedMap.put((Map)entry.getKey(), (List<Map<String, Object>>)entry.getValue());
            }
        }
        if (sortedMap.isEmpty()) {
            sortedMap.putAll(resultMap);
        }
        List realSortStatistics = sortStatistics.stream().filter(statistic -> !fieldListSet.contains(statistic.getStatisticalFields().get(0))).collect(Collectors.toList());
        String newLineField = null;
        for (Statistic sortStatistic : realSortStatistics) {
            if (StringUtils.isEmpty(sortStatistic.getMode()) || "normal".equals(sortStatistic.getMode())) continue;
            if ("custom".equals(sortStatistic.getMode())) {
                newLineField = sortStatistic.getSortName();
                break;
            }
            if (!"logical".equals(sortStatistic.getMode())) continue;
            newLineField = "lineNumber";
            break;
        }
        boolean bl2 = bl = newLineField != null;
        if (CollectionUtils.isNotEmpty(realSortStatistics)) {
            String finalNewLineField = newLineField;
            sortedMap.forEach((k, v) -> {
                v.sort(this.createComparator(realSortStatistics));
                if (isAddLineNumber) {
                    int i = 1;
                    for (Map stringObjectMap : v) {
                        stringObjectMap.put(finalNewLineField, i);
                        ++i;
                    }
                }
            });
        }
        return sortedMap;
    }

    private Comparator<Map.Entry<Map, List<Map<String, Object>>>> createGroupComparator(List<Statistic> sortStatistics) {
        Comparator<Map.Entry<Map, List<Map<String, Object>>>> comparator = Comparator.comparing(map -> 0);
        for (Statistic statistic : sortStatistics) {
            String field = statistic.getStatisticalFields().get(0);
            String direction = statistic.getType();
            Comparator<Map.Entry> fieldComparator = Comparator.comparing(map -> ((Map)map.getKey()).get(field), (value1, value2) -> {
                if (value1 == null || value2 == null) {
                    return value1 == null ? -1 : 1;
                }
                return this.compareValues(value1, value2);
            });
            if ("desc".equalsIgnoreCase(direction)) {
                fieldComparator = fieldComparator.reversed();
            }
            comparator = comparator.thenComparing(fieldComparator);
        }
        return comparator;
    }

    private Comparator<Map<String, Object>> createComparator(List<Statistic> sortStatistics) {
        Comparator<Map<String, Object>> comparator = Comparator.comparing(map -> 0);
        for (Statistic statistic : sortStatistics) {
            String field = statistic.getStatisticalFields().get(0);
            String direction = statistic.getType();
            Comparator<Map> fieldComparator = Comparator.comparing(map -> map.get(field), (value1, value2) -> {
                if (value1 == null || value2 == null) {
                    return value1 == null ? -1 : 1;
                }
                return this.compareValues(value1, value2);
            });
            if ("desc".equalsIgnoreCase(direction)) {
                fieldComparator = fieldComparator.reversed();
            }
            comparator = comparator.thenComparing(fieldComparator);
        }
        return comparator;
    }

    private int compareValues(Object value1, Object value2) {
        if (value1 instanceof Number && value2 instanceof Number) {
            return BigDecimal.valueOf(((Number)value1).doubleValue()).compareTo(BigDecimal.valueOf(((Number)value2).doubleValue()));
        }
        if (value1 instanceof String && value2 instanceof String) {
            String str1 = (String)value1;
            String str2 = (String)value2;
            if (RegexUtil.isNumber(str1) && RegexUtil.isNumber(str2)) {
                return new BigDecimal(str1).compareTo(new BigDecimal(str2));
            }
            return str1.compareTo(str2);
        }
        if (value1 instanceof Boolean && value2 instanceof Boolean) {
            return ((Boolean)value1).compareTo((Boolean)value2);
        }
        return value1.toString().compareTo(value2.toString());
    }

    public void doCalculate(Statistic statistic, Map<Map, List<Map<String, Object>>> resultMap) {
        BiConsumer<Statistic, Map<Map, List<Map<String, Object>>>> function = FUNCTION_MAP.get(statistic.getStatisticalMethod());
        if (function == null) {
            throw new RuntimeException("groupStep method not found,method:" + statistic.getStatisticalMethod());
        }
        function.accept(statistic, resultMap);
    }

    private static void addSortLineNumber(Map.Entry<Map, List<Map<String, Object>>> entry) {
        int i = 1;
        for (Map<String, Object> dataMap : entry.getValue()) {
            dataMap.put("lineNumber", i);
            ++i;
        }
    }

    private static void addSortLineNumber(Map.Entry<Map, List<Map<String, Object>>> entry, String sortColumnName) {
        int i = 1;
        for (Map<String, Object> dataMap : entry.getValue()) {
            dataMap.put(sortColumnName, i);
            ++i;
        }
    }

    private static void sort(List<String> sortFields, Map.Entry<Map, List<Map<String, Object>>> entry, String type) {
        Collections.sort(entry.getValue(), (o1, o2) -> {
            int i = 0;
            return GroupStep.compareData(sortFields, o1, o2, i++, type);
        });
    }

    private static int compareData(List<String> sortFields, Map<String, Object> o1, Map<String, Object> o2, int i, String type) {
        int result;
        if (i > sortFields.size() - 1) {
            return 0;
        }
        String sortField = sortFields.get(i);
        if (o1.get(sortField) == null || ObjectUtils.isEmpty((Object)o1.get(sortField))) {
            if ("asc".equals(type)) {
                return -1;
            }
            return 1;
        }
        if (o2.get(sortField) == null || ObjectUtils.isEmpty((Object)o2.get(sortField))) {
            if ("asc".equals(type)) {
                return 1;
            }
            return -1;
        }
        if (o1.get(sortField) instanceof String) {
            int result2;
            String sortValueA = String.valueOf(o1.get(sortField));
            String sortValueB = String.valueOf(o2.get(sortField));
            if (RegexUtil.isNumber(sortValueA) && RegexUtil.isNumber(sortValueB)) {
                int result3;
                BigDecimal bigDecimaA = new BigDecimal(sortValueA);
                BigDecimal bigDecimaB = new BigDecimal(sortValueB);
                int n = result3 = "asc".equals(type) ? bigDecimaA.compareTo(bigDecimaB) : bigDecimaB.compareTo(bigDecimaA);
                if (result3 == 0) {
                    return GroupStep.compareData(sortFields, o1, o2, i + 1, type);
                }
                return result3;
            }
            int n = result2 = "asc".equals(type) ? sortValueA.compareTo(sortValueB) : sortValueB.compareTo(sortValueA);
            if (result2 == 0) {
                return GroupStep.compareData(sortFields, o1, o2, i + 1, type);
            }
            return result2;
        }
        BigDecimal sortValueA = new BigDecimal(String.valueOf(o1.get(sortField)));
        BigDecimal sortValueB = new BigDecimal(String.valueOf(o2.get(sortField)));
        int n = result = "asc".equals(type) ? sortValueA.compareTo(sortValueB) : sortValueB.compareTo(sortValueA);
        if (result == 0) {
            return GroupStep.compareData(sortFields, o1, o2, i + 1, type);
        }
        return result;
    }

    private static String getMinDate(Statistic statistic, String min, Map dataMap) {
        String date = String.valueOf(dataMap.get(statistic.getStatisticalFields().get(0)));
        min = StringUtils.isEmpty(min) ? date : (date.compareTo(min) < 0 ? date : min);
        return min;
    }

    private static String getMaxDate(Statistic statistic, String max, Map dataMap) {
        String date = String.valueOf(dataMap.get(statistic.getStatisticalFields().get(0)));
        max = StringUtils.isEmpty(max) ? date : (date.compareTo(max) > 0 ? date : max);
        return max;
    }

    private static BigDecimal getMinNumber(Statistic statistic, BigDecimal min, Map dataMap) {
        Object data = dataMap.get(statistic.getStatisticalFields().get(0));
        BigDecimal bigDecimal = data == null ? new BigDecimal(0) : (data instanceof Double ? BigDecimal.valueOf((Double)data) : new BigDecimal(String.valueOf(data)));
        min = min != null ? (bigDecimal.compareTo(min) < 0 ? bigDecimal : min) : bigDecimal;
        return min;
    }

    private static BigDecimal getMaxNumber(Statistic statistic, BigDecimal max, Map dataMap) {
        Object data = dataMap.get(statistic.getStatisticalFields().get(0));
        BigDecimal bigDecimal = data == null ? new BigDecimal(0) : (data instanceof Double ? BigDecimal.valueOf((Double)data) : new BigDecimal(String.valueOf(data)));
        max = max != null ? (bigDecimal.compareTo(max) > 0 ? bigDecimal : max) : bigDecimal;
        return max;
    }

    private static void initFunction() {
        FUNCTION_MAP.put("sum", (statistic, resultMap) -> {
            for (Map.Entry entry : resultMap.entrySet()) {
                ((List)entry.getValue()).forEach(dataMap -> dataMap.put(statistic.getNewField(), GroupStep.getSumValue(statistic, entry)));
            }
        });
        FUNCTION_MAP.put("accSum", (statistic, resultMap) -> {
            for (Map.Entry entry : resultMap.entrySet()) {
                BigDecimal cumulativeSum = new BigDecimal(0);
                for (Map dataMap : (List)entry.getValue()) {
                    cumulativeSum = cumulativeSum.add(GroupStep.getBaseValue(statistic.getStatisticalFields(), dataMap));
                    dataMap.put(statistic.getNewField(), cumulativeSum);
                }
            }
        });
        FUNCTION_MAP.put("sort", (statistic, resultMap) -> {
            List<String> sortFields = statistic.getStatisticalFields();
            if ("normal".equals(statistic.getMode())) {
                for (Map.Entry<Map, List<Map<String, Object>>> entry : resultMap.entrySet()) {
                    GroupStep.sort(sortFields, entry, statistic.getType());
                }
            } else {
                for (Map.Entry<Map, List<Map<String, Object>>> entry : resultMap.entrySet()) {
                    GroupStep.sort(sortFields, entry, statistic.getType());
                    if ("custom".equals(statistic.getMode())) {
                        GroupStep.addSortLineNumber(entry, statistic.getSortName());
                        continue;
                    }
                    GroupStep.addSortLineNumber(entry);
                }
            }
        });
        FUNCTION_MAP.put("sortLimit", (statistic, resultMap) -> {
            int startPods = GroupStep.dealPods(statistic.getStartPos());
            int endPods = GroupStep.dealPods(statistic.getEndPos());
            List<String> sortFields = statistic.getStatisticalFields();
            for (Map.Entry<Map, List<Map<String, Object>>> entry : resultMap.entrySet()) {
                GroupStep.sort(sortFields, entry, statistic.getType());
                if (CollectionUtils.isEmpty(entry.getValue())) continue;
                int dataSize = entry.getValue().size();
                if (startPods > dataSize) {
                    resultMap.put(entry.getKey(), Lists.newArrayList());
                    continue;
                }
                endPods = Math.min(endPods, entry.getValue().size());
                resultMap.put(entry.getKey(), entry.getValue().subList(startPods, endPods));
            }
        });
        FUNCTION_MAP.put("count", (statistic, resultMap) -> {
            for (Map.Entry entry : resultMap.entrySet()) {
                int count = ((List)entry.getValue()).size();
                ((List)entry.getValue()).forEach(dataMap -> dataMap.put(statistic.getNewField(), count));
            }
        });
        FUNCTION_MAP.put("min", (statistic, resultMap) -> {
            for (Map.Entry entry : resultMap.entrySet()) {
                String finalMin;
                Object min;
                if ("date".equals(statistic.getType())) {
                    min = "";
                    for (Map dataMap2 : (List)entry.getValue()) {
                        min = GroupStep.getMinDate(statistic, (String)min, dataMap2);
                    }
                    finalMin = min;
                } else if ("number".equals(statistic.getType())) {
                    min = null;
                    for (Map dataMap2 : (List)entry.getValue()) {
                        min = GroupStep.getMinNumber(statistic, (BigDecimal)min, dataMap2);
                    }
                    finalMin = min;
                } else {
                    finalMin = "";
                }
                ((List)entry.getValue()).forEach(dataMap -> dataMap.put(statistic.getNewField(), finalMin));
            }
        });
        FUNCTION_MAP.put("max", (statistic, resultMap) -> {
            for (Map.Entry entry : resultMap.entrySet()) {
                String finalMax;
                Object max;
                if ("date".equals(statistic.getType())) {
                    max = "";
                    for (Map dataMap2 : (List)entry.getValue()) {
                        max = GroupStep.getMaxDate(statistic, (String)max, dataMap2);
                    }
                    finalMax = max;
                } else if ("number".equals(statistic.getType())) {
                    max = null;
                    for (Map dataMap2 : (List)entry.getValue()) {
                        max = GroupStep.getMaxNumber(statistic, (BigDecimal)max, dataMap2);
                    }
                    finalMax = max;
                } else if ("string".equals(statistic.getType())) {
                    max = "";
                    for (Map dataMap2 : (List)entry.getValue()) {
                        max = GroupStep.getMaxString(statistic, (String)max, dataMap2);
                    }
                    finalMax = max;
                } else {
                    finalMax = "";
                }
                ((List)entry.getValue()).forEach(dataMap -> dataMap.put(statistic.getNewField(), finalMax));
            }
        });
        FUNCTION_MAP.put("average", (statistic, resultMap) -> {
            for (Map.Entry entry : resultMap.entrySet()) {
                AtomicInteger counter = new AtomicInteger();
                BigDecimal sumValue = ((List)entry.getValue()).stream().map(map -> {
                    boolean allFieldsNonEmpty = statistic.getStatisticalFields().stream().allMatch(item -> map.get(item) instanceof Number || map.get(item) instanceof String && StringUtils.isNotEmpty((String)map.get(item)));
                    if (allFieldsNonEmpty) {
                        counter.incrementAndGet();
                    }
                    return statistic.getStatisticalFields().stream().map(item -> {
                        if (map.get(item) instanceof Number) {
                            return new BigDecimal(((Number)map.get(item)).toString());
                        }
                        if (map.get(item) instanceof String && StringUtils.isNotEmpty((String)map.get(item))) {
                            return new BigDecimal((String)map.get(item));
                        }
                        return BigDecimal.ZERO;
                    }).reduce(BigDecimal.ZERO, BigDecimal::add);
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                int count = counter.get();
                BigDecimal aveValue = !sumValue.equals(BigDecimal.ZERO) && count != 0 ? sumValue.divide(new BigDecimal(count), (int)CalculateStep.getPrecision(statistic.getPrecision()), CalculateStep.getRoundingMode(statistic.getPrecisionType())) : BigDecimal.ZERO;
                ((List)entry.getValue()).forEach(dataMap -> dataMap.put(statistic.getNewField(), aveValue));
            }
        });
        FUNCTION_MAP.put("limit", (statistic, resultMap) -> {
            Integer startPods = GroupStep.dealPods(statistic.getStartPos());
            Integer endPods = GroupStep.dealPods(statistic.getEndPos());
            for (Map.Entry entry : resultMap.entrySet()) {
                ArrayList<Map<String, Object>> newValues = new ArrayList<Map<String, Object>>(endPods - startPods + 1);
                List values = (List)entry.getValue();
                if (startPods >= 0 || startPods <= endPods || startPods <= values.size()) {
                    if ("tail".equals(statistic.getDirection())) {
                        int newEndPods = values.size() - startPods - 1;
                        int newStartPods = endPods <= values.size() ? values.size() - endPods - 1 : values.size() - 1;
                        GroupStep.limitValue(newStartPods, newEndPods, newValues, values);
                    } else {
                        if (endPods >= values.size()) {
                            endPods = values.size() - 1;
                        }
                        GroupStep.limitValue(startPods, endPods, newValues, values);
                    }
                }
                resultMap.put(entry.getKey(), newValues);
            }
        });
        FUNCTION_MAP.put("collection", (statistic, resultMap) -> {
            for (Map.Entry entry : resultMap.entrySet()) {
                HashSet set = new HashSet();
                for (Map dataMap2 : (List)entry.getValue()) {
                    set.add(dataMap2.get(statistic.getStatisticalFields().get(0)));
                }
                String newFieldValue = StringUtils.join(set, ",");
                ((List)entry.getValue()).forEach(dataMap -> dataMap.put(statistic.getNewField(), newFieldValue));
            }
        });
        FUNCTION_MAP.put("ratio", (statistic, resultMap) -> {
            for (Map.Entry<Map, List<Map<String, Object>>> entry : resultMap.entrySet()) {
                BigDecimal sumValue = GroupStep.getSumValue(statistic, entry);
                if (sumValue.compareTo(BigDecimal.ZERO) == 0) {
                    if (!"divideDefault".equals(statistic.getExceptionHandling())) continue;
                    entry.getValue().forEach(dataMap -> dataMap.put(statistic.getNewField(), BigDecimal.ZERO));
                    continue;
                }
                entry.getValue().forEach(map -> {
                    for (String item : statistic.getStatisticalFields()) {
                        double value;
                        Object valueObj = map.get(item);
                        if (valueObj == null) {
                            LOGGER.warn("Group ratio error, value is null for field: {}", (Object)item);
                            map.put(statistic.getNewField(), BigDecimal.ZERO);
                            continue;
                        }
                        if (valueObj instanceof Number) {
                            value = ((Number)valueObj).doubleValue();
                        } else if (valueObj instanceof String && StringUtils.isNotEmpty((String)valueObj)) {
                            value = Double.parseDouble((String)valueObj);
                        } else {
                            LOGGER.warn("Group ratio error, value is not a valid number or field, key: {}, value: {}", (Object)item, valueObj);
                            continue;
                        }
                        BigDecimal valueA = BigDecimal.valueOf(value);
                        BigDecimal divide = valueA.divide(sumValue, (int)CalculateStep.getPrecision(statistic.getPrecision()), CalculateStep.getRoundingMode(statistic.getPrecisionType()));
                        map.put(statistic.getNewField(), new BigDecimal(divide.stripTrailingZeros().toPlainString()));
                    }
                });
            }
        });
        FUNCTION_MAP.put("variance", (statistic, resultMap) -> {
            for (Map.Entry<Map, List<Map<String, Object>>> entry : resultMap.entrySet()) {
                DescriptiveStatistics stats = new DescriptiveStatistics();
                GroupStep.handleStatsList(statistic, entry, stats);
                if (stats.getN() > 0L) {
                    BigDecimal resultValue = CalculateStep.getResultValue(statistic.getPrecision(), BigDecimal.valueOf(stats.getVariance()), CalculateStep.getRoundingMode(statistic.getPrecisionType()));
                    entry.getValue().forEach(dataMap -> dataMap.put(statistic.getNewField(), resultValue));
                    continue;
                }
                entry.getValue().forEach(dataMap -> dataMap.put(statistic.getNewField(), BigDecimal.ZERO));
            }
        });
        FUNCTION_MAP.put("stddev_samp", (statistic, resultMap) -> {
            for (Map.Entry<Map, List<Map<String, Object>>> entry : resultMap.entrySet()) {
                DescriptiveStatistics stats = new DescriptiveStatistics();
                GroupStep.handleStatsList(statistic, entry, stats);
                if (stats.getN() > 0L) {
                    BigDecimal resultValue = CalculateStep.getResultValue(statistic.getPrecision(), BigDecimal.valueOf(stats.getStandardDeviation()), CalculateStep.getRoundingMode(statistic.getPrecisionType()));
                    entry.getValue().forEach(dataMap -> dataMap.put(statistic.getNewField(), resultValue));
                    continue;
                }
                entry.getValue().forEach(dataMap -> dataMap.put(statistic.getNewField(), BigDecimal.ZERO));
            }
        });
        FUNCTION_MAP.put("stddev", (statistic, resultMap) -> {
            for (Map.Entry<Map, List<Map<String, Object>>> entry : resultMap.entrySet()) {
                DescriptiveStatistics stats = new DescriptiveStatistics();
                GroupStep.handleStatsList(statistic, entry, stats);
                if (stats.getN() > 0L) {
                    double populationStdDev = stats.getStandardDeviation() * Math.sqrt((double)(stats.getN() - 1L) / (double)stats.getN());
                    BigDecimal resultValue = CalculateStep.getResultValue(statistic.getPrecision(), BigDecimal.valueOf(populationStdDev), CalculateStep.getRoundingMode(statistic.getPrecisionType()));
                    entry.getValue().forEach(dataMap -> dataMap.put(statistic.getNewField(), resultValue));
                    continue;
                }
                entry.getValue().forEach(dataMap -> dataMap.put(statistic.getNewField(), BigDecimal.ZERO));
            }
        });
        FUNCTION_MAP.put("irr", (statistic, resultMap) -> {
            for (Map.Entry<Map, List<Map<String, Object>>> entry : resultMap.entrySet()) {
                BigDecimal resultValue;
                List<Double> cashFlows = GroupStep.handleDoubleValue(statistic, entry);
                if (!cashFlows.isEmpty()) {
                    UnivariateFunction npvFunction = r -> {
                        double npv = 0.0;
                        for (int i = 0; i < cashFlows.size(); ++i) {
                            npv += (Double)cashFlows.get(i) / Math.pow(1.0 + r, i);
                        }
                        return npv;
                    };
                    int maximumIterations = StringUtils.isBlank(statistic.getMaximumIterations()) ? Integer.parseInt("100") : Integer.parseInt(statistic.getMaximumIterations());
                    int startPos = StringUtils.isBlank(statistic.getStartPos()) ? Integer.parseInt("-1") : Integer.parseInt(statistic.getStartPos());
                    int endPos = StringUtils.isBlank(statistic.getEndPos()) ? Integer.parseInt("1") : Integer.parseInt(statistic.getEndPos());
                    BrentSolver solver = new BrentSolver();
                    double irr = solver.solve(maximumIterations, npvFunction, startPos, endPos);
                    resultValue = CalculateStep.getResultValue(statistic.getPrecision(), BigDecimal.valueOf(irr), CalculateStep.getRoundingMode(statistic.getPrecisionType()));
                } else {
                    resultValue = BigDecimal.ZERO;
                }
                entry.getValue().forEach(dataMap -> dataMap.put(statistic.getNewField(), resultValue));
            }
        });
        FUNCTION_MAP.put("npv", (statistic, resultMap) -> {
            for (Map.Entry<Map, List<Map<String, Object>>> entry : resultMap.entrySet()) {
                BigDecimal resultValue;
                List<Double> cashFlows = GroupStep.handleDoubleValue(statistic, entry);
                if (!cashFlows.isEmpty()) {
                    double rate = Double.parseDouble(statistic.getRate());
                    BigDecimal value = BigDecimal.valueOf(IntStream.range(0, cashFlows.size()).mapToDouble(i -> (Double)cashFlows.get(i) / Math.pow(1.0 + rate, i)).sum());
                    resultValue = CalculateStep.getResultValue(statistic.getPrecision(), value, CalculateStep.getRoundingMode(statistic.getPrecisionType()));
                } else {
                    resultValue = BigDecimal.ZERO;
                }
                entry.getValue().forEach(dataMap -> dataMap.put(statistic.getNewField(), resultValue));
            }
        });
    }

    private static BigDecimal getBaseValue(List<String> statisticalFields, Map<String, Object> dataMap) {
        return statisticalFields.stream().map(item -> {
            Object value = dataMap.get(item);
            if (value instanceof Number) {
                return new BigDecimal(value.toString());
            }
            if (value instanceof String && StringUtils.isNotEmpty((String)value)) {
                return new BigDecimal((String)value);
            }
            return BigDecimal.ZERO;
        }).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static BigDecimal getSumValue(Statistic statistic, Map.Entry<Map, List<Map<String, Object>>> entry) {
        try {
            return entry.getValue().stream().map(map -> statistic.getStatisticalFields().stream().map(item -> {
                Object value = map.get(item);
                if (value instanceof Number) {
                    return new BigDecimal(value.toString());
                }
                if (value instanceof String && StringUtils.isNotEmpty((String)value)) {
                    return new BigDecimal((String)value);
                }
                return BigDecimal.ZERO;
            }).reduce(BigDecimal.ZERO, BigDecimal::add)).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        catch (NumberFormatException e) {
            LOGGER.error("\u6570\u503c\u8f6c\u6362\u9519\u8bef: {}", (Object)e.getMessage());
            return BigDecimal.ZERO;
        }
        catch (Exception e) {
            LOGGER.error("\u8ba1\u7b97\u603b\u548c\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage());
            return BigDecimal.ZERO;
        }
    }

    private static void handleStatsList(Statistic statistic, Map.Entry<Map, List<Map<String, Object>>> entry, DescriptiveStatistics stats) {
        entry.getValue().forEach(map -> {
            for (String item : statistic.getStatisticalFields()) {
                double value;
                Object valueObj = map.get(item);
                if (valueObj == null) {
                    LOGGER.warn("Group error, value is null for field: {}", (Object)item);
                    continue;
                }
                if (valueObj instanceof Number) {
                    value = ((Number)valueObj).doubleValue();
                } else if (valueObj instanceof String && String.valueOf(valueObj).matches("-?\\d+")) {
                    value = Double.parseDouble(String.valueOf(valueObj));
                } else {
                    LOGGER.warn("Group error, value is not a valid number or field,key: {}, value: {}", (Object)item, valueObj);
                    continue;
                }
                stats.addValue(value);
            }
        });
    }

    private static String getMaxString(Statistic statistic, String max, Map dataMap) {
        String date = String.valueOf(dataMap.get(statistic.getStatisticalFields().get(0)));
        max = StringUtils.isEmpty(max) ? date : (date.compareTo(max) > 0 ? date : max);
        return max;
    }

    private static void limitValue(int startPods, int endPods, List<Map<String, Object>> newValues, List<Map<String, Object>> values) {
        for (int i = startPods; i <= endPods; ++i) {
            newValues.add(values.get(i));
        }
    }

    private static Integer dealPods(String pods) {
        if (StringUtils.isBlank(pods)) {
            return 0;
        }
        return Integer.valueOf(pods);
    }

    private static List<Double> handleDoubleValue(Statistic statistic, Map.Entry<Map, List<Map<String, Object>>> entry) {
        ArrayList<Double> values = new ArrayList<Double>();
        entry.getValue().forEach(map -> {
            for (String item : statistic.getStatisticalFields()) {
                double value;
                Object valueObj = map.get(item);
                if (valueObj == null) {
                    LOGGER.warn("Group error, value is null for field: {}", (Object)item);
                    continue;
                }
                if (valueObj instanceof Number) {
                    value = ((Number)valueObj).doubleValue();
                } else if (valueObj instanceof String && String.valueOf(valueObj).matches("-?\\d+")) {
                    value = Double.parseDouble(String.valueOf(valueObj));
                } else {
                    LOGGER.warn("Group error, value is not a valid number or field,key: {}, value: {}", (Object)item, valueObj);
                    continue;
                }
                values.add(value);
            }
        });
        return values;
    }

    static {
        GroupStep.initFunction();
    }
}

