/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.operator;

import com.digiwin.athena.executionengine.trans.util.RegexUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class OperatorFactory {
    private static Map<String, OperatorFunction<Object>> FUNCTION_MAP = new HashMap<String, OperatorFunction<Object>>();

    public static OperatorFunction getOperatorFunction(String type) {
        return FUNCTION_MAP.get(type);
    }

    static {
        FUNCTION_MAP.put("and", objects -> {
            for (Object obj : objects) {
                boolean isMatch = (Boolean)obj;
                if (isMatch) continue;
                return isMatch;
            }
            return true;
        });
        FUNCTION_MAP.put("eq", objects -> {
            String origin = String.valueOf(objects[0]);
            String target = String.valueOf(objects[1]);
            if (StringUtils.isBlank(origin) || StringUtils.isBlank(target)) {
                return false;
            }
            if (RegexUtil.isNumber(origin) && RegexUtil.isNumber(target)) {
                BigDecimal targetDecimal;
                BigDecimal originDecimal = new BigDecimal(String.valueOf(objects[0]));
                return originDecimal.compareTo(targetDecimal = new BigDecimal(String.valueOf(objects[1]))) == 0;
            }
            return String.valueOf(objects[0]).equals(String.valueOf(objects[1]));
        });
        FUNCTION_MAP.put("gte", objects -> {
            BigDecimal targetDecimal;
            BigDecimal originDecimal = new BigDecimal(String.valueOf(objects[0]));
            return originDecimal.compareTo(targetDecimal = new BigDecimal(String.valueOf(objects[1]))) >= 0;
        });
        FUNCTION_MAP.put("gt", objects -> {
            BigDecimal targetDecimal;
            BigDecimal originDecimal = new BigDecimal(String.valueOf(objects[0]));
            return originDecimal.compareTo(targetDecimal = new BigDecimal(String.valueOf(objects[1]))) > 0;
        });
        FUNCTION_MAP.put("lte", objects -> {
            BigDecimal targetDecimal;
            BigDecimal originDecimal = new BigDecimal(String.valueOf(objects[0]));
            return originDecimal.compareTo(targetDecimal = new BigDecimal(String.valueOf(objects[1]))) <= 0;
        });
        FUNCTION_MAP.put("lt", objects -> {
            BigDecimal targetDecimal;
            BigDecimal originDecimal = new BigDecimal(String.valueOf(objects[0]));
            return originDecimal.compareTo(targetDecimal = new BigDecimal(String.valueOf(objects[1]))) < 0;
        });
        FUNCTION_MAP.put("neq", objects -> {
            String origin = String.valueOf(objects[0]);
            String target = String.valueOf(objects[1]);
            if (StringUtils.isBlank(origin) || StringUtils.isBlank(target)) {
                return false;
            }
            if (RegexUtil.isNumber(origin) && RegexUtil.isNumber(target)) {
                BigDecimal targetDecimal;
                BigDecimal originDecimal = new BigDecimal(String.valueOf(objects[0]));
                return originDecimal.compareTo(targetDecimal = new BigDecimal(String.valueOf(objects[1]))) != 0;
            }
            return !String.valueOf(objects[0]).equals(String.valueOf(objects[1]));
        });
        FUNCTION_MAP.put("or", objects -> {
            for (Object obj : objects) {
                boolean isMatch = (Boolean)obj;
                if (!isMatch) continue;
                return true;
            }
            return false;
        });
        FUNCTION_MAP.put("pm", objects -> {
            String value = String.valueOf(objects[0]);
            String prefix = String.valueOf(objects[1]);
            if (StringUtils.isEmpty(value) || StringUtils.isEmpty(prefix)) {
                return false;
            }
            return value.startsWith(prefix);
        });
        FUNCTION_MAP.put("sm", objects -> {
            String value = String.valueOf(objects[0]);
            String suffix = String.valueOf(objects[1]);
            if (StringUtils.isEmpty(value) || StringUtils.isEmpty(suffix)) {
                return false;
            }
            return value.endsWith(suffix);
        });
        FUNCTION_MAP.put("fm", objects -> {
            String value = String.valueOf(objects[0]);
            String key = String.valueOf(objects[1]);
            if (StringUtils.isEmpty(value) || StringUtils.isEmpty(key)) {
                return false;
            }
            return value.contains(key);
        });
        FUNCTION_MAP.put("in", objects -> {
            Object value = objects[0];
            List collections = (List)objects[1];
            HashSet set = new HashSet(collections);
            return set.contains(value);
        });
        FUNCTION_MAP.put("nin", objects -> {
            List collections = (List)objects[1];
            HashSet set = new HashSet(collections);
            Object value = objects[0];
            return !set.contains(value);
        });
        FUNCTION_MAP.put("is_null", objects -> objects[0] == null);
        FUNCTION_MAP.put("is_not_null", objects -> objects[0] != null);
    }

    @FunctionalInterface
    public static interface OperatorFunction<T> {
        public boolean apply(T ... var1);
    }
}

