/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.trans.components.InputStep;
import com.digiwin.athena.executionengine.trans.pojo.element.DealResult;
import com.digiwin.athena.executionengine.trans.pojo.element.JoinSelectElement;
import com.digiwin.athena.executionengine.trans.pojo.element.StepElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="join")
public class JoinStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStep.class);

    @Override
    public boolean defineCheck(StepElement stepElement) {
        return true;
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        StepElement stepElement = step.getStepElement();
        try {
            String dataLtName = stepElement.getDataLt();
            Object dataLt = this.getCurrentData(dataLtName);
            String dataRtName = stepElement.getDataRt();
            Object dataRt = this.getCurrentData(dataRtName);
            if (dataLt == null && "left".equals(stepElement.getType())) {
                dealResult.setSuccess(new ArrayList());
                return dealResult;
            }
            if (dataRt == null && "left".equals(stepElement.getType())) {
                dealResult.setSuccess(dataLt);
                return dealResult;
            }
            if (dataRt == null && "right".equals(stepElement.getType())) {
                dealResult.setSuccess(new ArrayList());
                return dealResult;
            }
            if (dataLt == null && "right".equals(stepElement.getType())) {
                dealResult.setSuccess(dataRt);
                return dealResult;
            }
            if (dataLt == null && "full".equals(stepElement.getType())) {
                dealResult.setSuccess(dataRt);
                return dealResult;
            }
            if (dataRt == null && "full".equals(stepElement.getType())) {
                dealResult.setSuccess(dataLt);
                return dealResult;
            }
            if (dataLt == null && "inner".equals(stepElement.getType())) {
                dealResult.setSuccess(dataRt);
                return dealResult;
            }
            if (dataRt == null && "inner".equals(stepElement.getType())) {
                dealResult.setSuccess(dataLt);
                return dealResult;
            }
            if (dataLt == null && "cross".equals(stepElement.getType())) {
                dealResult.setSuccess(dataRt);
                return dealResult;
            }
            if (dataRt == null && "cross".equals(stepElement.getType())) {
                dealResult.setSuccess(dataLt);
                return dealResult;
            }
            List leftList = (List)dataLt;
            List rightList = (List)dataRt;
            List<String> leftFields = stepElement.getLeftFields();
            List<String> rightFields = stepElement.getRightFields();
            List<JoinSelectElement> selectLtFieldList = stepElement.getSelectLtFields();
            List<JoinSelectElement> selectRtFieldList = stepElement.getSelectRtFields();
            selectLtFieldList = this.analyseSelectKeys(dataLtName, selectLtFieldList);
            selectRtFieldList = this.analyseSelectKeys(dataRtName, selectRtFieldList);
            if ("right".equals(stepElement.getType())) {
                for (JoinSelectElement jse : selectLtFieldList) {
                    if (leftFields.contains(jse.getNewField())) continue;
                    selectRtFieldList.add(jse);
                }
            }
            List<Object> data = new ArrayList();
            if ("left".equals(stepElement.getType())) {
                data = this.joinData(leftList, rightList, selectLtFieldList, selectRtFieldList, leftFields, rightFields, stepElement.isEnableOnFieldCompletion());
            } else if ("right".equals(stepElement.getType())) {
                data = this.joinData(rightList, leftList, selectRtFieldList, selectLtFieldList, rightFields, leftFields, stepElement.isEnableOnFieldCompletion());
            } else if ("full".equals(stepElement.getType())) {
                List<Map<String, Object>> leftDatas = this.joinData(leftList, rightList, selectLtFieldList, selectRtFieldList, leftFields, rightFields, stepElement.isEnableOnFieldCompletion());
                List<Map<String, Object>> rightDatas = this.joinData(rightList, leftList, selectRtFieldList, selectLtFieldList, rightFields, leftFields, stepElement.isEnableOnFieldCompletion());
                leftDatas.addAll(rightDatas);
                ArrayList<HashMap<String, Object>> mergedDeduplicatedList = new ArrayList<HashMap<String, Object>>();
                HashSet<HashMap<String, Object>> set = new HashSet<HashMap<String, Object>>();
                for (Map<String, Object> map : leftDatas) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
                    if (!set.add(hashMap)) continue;
                    mergedDeduplicatedList.add(hashMap);
                }
                data = mergedDeduplicatedList;
            } else if ("inner".equals(stepElement.getType())) {
                data = this.innerJoinData(leftList, rightList, selectLtFieldList, selectRtFieldList, leftFields, rightFields);
            } else if ("cross".equals(stepElement.getType())) {
                data = this.crossJoinData(leftList, rightList, selectLtFieldList, selectRtFieldList);
            }
            dealResult.setSuccess(data);
            return dealResult;
        }
        catch (Exception e) {
            LOGGER.error("join\u7ec4\u4ef6\u51fa\u73b0\u5f02\u5e38");
            throw e;
        }
    }

    private List<JoinSelectElement> analyseSelectKeys(String stepName, List<JoinSelectElement> selectFieldList) {
        ArrayList<JoinSelectElement> selectList = new ArrayList<JoinSelectElement>();
        Object record = null;
        Object stepData = this.getTransDataManager().getStepDataCollection(stepName);
        if (stepData instanceof List && CollectionUtils.isNotEmpty((List)stepData)) {
            record = ((ArrayList)this.getTransDataManager().getStepDataCollection(stepName)).get(0);
        } else if (stepData instanceof Map) {
            record = stepData;
        }
        if (record == null) {
            return Collections.EMPTY_LIST;
        }
        Map map = (Map)record;
        if (CollectionUtils.isEmpty(selectFieldList)) {
            map.forEach((k, v) -> {
                if (v instanceof Number) {
                    selectList.add(new JoinSelectElement((String)k, (String)k, "number"));
                } else if (v instanceof Boolean) {
                    selectList.add(new JoinSelectElement((String)k, (String)k, "boolean"));
                } else {
                    selectList.add(new JoinSelectElement((String)k, (String)k, "string"));
                }
            });
            return selectList;
        }
        for (JoinSelectElement jse : selectFieldList) {
            if (map.get(jse.getField()) instanceof Number) {
                selectList.add(new JoinSelectElement(jse.getField(), jse.getField(), "number"));
                continue;
            }
            if (map.get(jse.getField()) instanceof Boolean) {
                selectList.add(new JoinSelectElement(jse.getField(), jse.getField(), "boolean"));
                continue;
            }
            selectList.add(new JoinSelectElement(jse.getField(), jse.getField(), "string"));
        }
        return selectList;
    }

    private List<Map<String, Object>> joinData(List<Map<String, Object>> leftList, List<Map<String, Object>> rightList, List<JoinSelectElement> selectLtFieldList, List<JoinSelectElement> selectRtFieldList, List<String> leftFields, List<String> rightFields, boolean enableOnFieldCompletion) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map<String, List<Map>> map2Index = rightList.stream().collect(Collectors.groupingBy(map -> this.buildIndexKey((Map<String, Object>)map, rightFields)));
        for (Map<String, Object> left : leftList) {
            String key = this.buildIndexKey(left, leftFields);
            List<Map> rightData = map2Index.get(key);
            if (CollectionUtils.isEmpty(rightData)) {
                this.combineJoinRow(selectLtFieldList, selectRtFieldList, list, left, null, leftFields, rightFields, enableOnFieldCompletion);
                continue;
            }
            for (Map right : rightData) {
                this.combineJoinRow(selectLtFieldList, selectRtFieldList, list, left, right, leftFields, rightFields, enableOnFieldCompletion);
            }
        }
        return list;
    }

    private String buildIndexKey(Map<String, Object> data, List<String> fields) {
        StringBuilder indexKey = new StringBuilder();
        for (String field : fields) {
            indexKey.append(data.get(field));
            indexKey.append("&&");
        }
        return indexKey.toString();
    }

    private boolean checkIsMatch(List<String> leftFields, List<String> rightFields, Map<String, Object> left, Map<String, Object> right) {
        boolean isMatch = true;
        for (int i = 0; i < leftFields.size(); ++i) {
            if (Objects.equals(left.get(leftFields.get(i)), right.get(rightFields.get(i)))) continue;
            isMatch = false;
            break;
        }
        return isMatch;
    }

    private void combineJoinRow(List<JoinSelectElement> selectLtFieldList, List<JoinSelectElement> selectRtFieldList, List<Map<String, Object>> list, Map<String, Object> left, Map<String, Object> right, List<String> leftFields, List<String> rightFields, boolean enableOnFieldCompletion) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (JoinSelectElement element : selectLtFieldList) {
            map.put(element.getNewField(), left.get(element.getField()));
        }
        if (CollectionUtils.isNotEmpty(selectRtFieldList)) {
            for (JoinSelectElement element : selectRtFieldList) {
                String newField = element.getNewField();
                String rightField = element.getField();
                if (right != null) {
                    map.put(newField, right.get(rightField));
                    continue;
                }
                int idx = rightFields.indexOf(rightField);
                if (idx != -1 && enableOnFieldCompletion) {
                    String leftField = leftFields.get(idx);
                    map.put(newField, left.get(leftField));
                    continue;
                }
                map.put(newField, this.getJoinDefaultValue(element.getType()));
            }
        } else {
            rightFields.forEach(key -> {
                int idx = rightFields.indexOf(key);
                if (idx != -1 && enableOnFieldCompletion) {
                    String leftField = (String)leftFields.get(idx);
                    map.put((String)key, left.get(leftField));
                }
            });
        }
        list.add(map);
    }

    private void mergeData(List<JoinSelectElement> selectLtFieldList, List<JoinSelectElement> selectRtFieldList, List<Map<String, Object>> list, Map<String, Object> left, Map<String, Object> right) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (JoinSelectElement element : selectLtFieldList) {
            map.put(element.getNewField(), left.get(element.getField()));
        }
        for (JoinSelectElement element : selectRtFieldList) {
            if (right != null) {
                map.put(element.getNewField(), right.get(element.getField()));
                continue;
            }
            if (map.containsKey(element.getNewField())) continue;
            map.put(element.getNewField(), this.getJoinDefaultValue(element.getType()));
        }
        list.add(map);
    }

    private Object getJoinDefaultValue(String type) {
        switch (type) {
            case "number": {
                return 0;
            }
            case "boolean": {
                return false;
            }
        }
        return "";
    }

    private List<Map<String, Object>> innerJoinData(List<Map<String, Object>> leftList, List<Map<String, Object>> rightList, List<JoinSelectElement> selectLtFieldList, List<JoinSelectElement> selectRtFieldList, List<String> leftFields, List<String> rightFields) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map<String, List<Map>> map2Index = rightList.stream().collect(Collectors.groupingBy(map -> this.buildIndexKey((Map<String, Object>)map, rightFields)));
        for (Map<String, Object> left : leftList) {
            String key = this.buildIndexKey(left, leftFields);
            List<Map> rightData = map2Index.get(key);
            if (CollectionUtils.isEmpty(rightData)) continue;
            for (Map right : rightData) {
                this.mergeData(selectLtFieldList, selectRtFieldList, list, left, right);
            }
        }
        return list;
    }

    private List<Map<String, Object>> crossJoinData(List<Map<String, Object>> leftList, List<Map<String, Object>> rightList, List<JoinSelectElement> selectLtFieldList, List<JoinSelectElement> selectRtFieldList) {
        if (CollectionUtils.isEmpty(leftList)) {
            return rightList;
        }
        if (CollectionUtils.isEmpty(rightList)) {
            return leftList;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> left : leftList) {
            for (Map<String, Object> right : rightList) {
                this.mergeData(selectLtFieldList, selectRtFieldList, list, left, right);
            }
        }
        return list;
    }
}

