/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.meta.activity;

import com.digiwin.athena.uibot.meta.activity.GroupMetadataField;
import com.digiwin.athena.uibot.meta.activity.Precision;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class MetadataField
implements Serializable {
    private String name;
    private String originalName;
    private String path;
    private boolean required;
    private String description;
    private String remark;
    private String dataKey;
    private boolean businessKey;
    private String dataType;
    @JsonIgnore
    private int displayWidth;
    private Precision precision;
    private Object objectData;
    private Boolean canSort;
    private Boolean canFilter;
    private String fieldType;
    private boolean canEdit;
    private List<MetadataField> subFields;
    @JsonIgnore
    private List<MetadataField> exportTableFields;
    private boolean array;
    @JsonIgnore
    private String sourceApi;
    @JsonIgnore
    private boolean isHead;
    @JsonIgnore
    private String clientAgent;
    private String enumKey;
    @JsonIgnore
    private Map<String, MetadataField> fieldMap;
    @JsonIgnore
    private MetadataField parentField;
    private String percent;
    private Integer decimal;
    @JsonIgnore
    private List<GroupMetadataField> groupMetadataFields;
    private GroupMetadataField groupMetadataField;
    private String uiBot;
    private Boolean isNavigate = Boolean.FALSE;

    public static MetadataField createArrayField(String name, String description, String path, boolean canEdit) {
        MetadataField detailField = new MetadataField();
        detailField.setFieldType("object");
        detailField.setName(name);
        detailField.setDescription(description);
        detailField.setDataType("object");
        detailField.setArray(true);
        detailField.setCanEdit(canEdit);
        detailField.setSubFields(new ArrayList<MetadataField>());
        detailField.setPath(StringUtils.isEmpty((Object)path) ? name : path + "." + name);
        return detailField;
    }

    public static MetadataField createObjectField(String name, String description, String path, boolean canEdit) {
        MetadataField detailField = new MetadataField();
        detailField.setFieldType("object");
        detailField.setName(name);
        detailField.setDescription(description);
        detailField.setDataType("object");
        detailField.setArray(false);
        detailField.setSubFields(new ArrayList<MetadataField>());
        detailField.setCanEdit(canEdit);
        detailField.setPath(StringUtils.isEmpty((Object)path) ? name : path + "." + name);
        return detailField;
    }

    public static MetadataField createSimpleField(String name, String description, String type, String path, boolean canEdit) {
        MetadataField detailField = new MetadataField();
        detailField.setFieldType(type);
        detailField.setName(name);
        detailField.setDescription(description);
        detailField.setDataType(type);
        detailField.setArray(false);
        detailField.setCanEdit(canEdit);
        detailField.setPath(StringUtils.isEmpty((Object)path) ? name : path + "." + name);
        return detailField;
    }

    private static MetadataField createStringField(String name, String description, String path, boolean canEdit) {
        return MetadataField.createSimpleField(name, description, "string", path, canEdit);
    }

    @JsonIgnore
    public String getFullName() {
        if (StringUtils.hasText((String)this.getPath())) {
            return this.getPath() + '.' + this.getName();
        }
        return this.getName();
    }

    public boolean isSingleHead() {
        return this.getPath() == null || this.getParentField() == null;
    }

    public boolean isNotSingleHead() {
        return !this.isSingleHead();
    }

    public String toString() {
        return this.getName();
    }

    public static MetadataFieldBuilder builder() {
        return new MetadataFieldBuilder();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setDataKey(String dataKey) {
        this.dataKey = dataKey;
    }

    public void setBusinessKey(boolean businessKey) {
        this.businessKey = businessKey;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setDisplayWidth(int displayWidth) {
        this.displayWidth = displayWidth;
    }

    public void setPrecision(Precision precision) {
        this.precision = precision;
    }

    public void setObjectData(Object objectData) {
        this.objectData = objectData;
    }

    public void setCanSort(Boolean canSort) {
        this.canSort = canSort;
    }

    public void setCanFilter(Boolean canFilter) {
        this.canFilter = canFilter;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public void setSubFields(List<MetadataField> subFields) {
        this.subFields = subFields;
    }

    public void setExportTableFields(List<MetadataField> exportTableFields) {
        this.exportTableFields = exportTableFields;
    }

    public void setArray(boolean array) {
        this.array = array;
    }

    public void setSourceApi(String sourceApi) {
        this.sourceApi = sourceApi;
    }

    public void setHead(boolean isHead) {
        this.isHead = isHead;
    }

    public void setClientAgent(String clientAgent) {
        this.clientAgent = clientAgent;
    }

    public void setEnumKey(String enumKey) {
        this.enumKey = enumKey;
    }

    public void setFieldMap(Map<String, MetadataField> fieldMap) {
        this.fieldMap = fieldMap;
    }

    public void setParentField(MetadataField parentField) {
        this.parentField = parentField;
    }

    public void setPercent(String percent) {
        this.percent = percent;
    }

    public void setDecimal(Integer decimal) {
        this.decimal = decimal;
    }

    public void setGroupMetadataFields(List<GroupMetadataField> groupMetadataFields) {
        this.groupMetadataFields = groupMetadataFields;
    }

    public void setGroupMetadataField(GroupMetadataField groupMetadataField) {
        this.groupMetadataField = groupMetadataField;
    }

    public void setUiBot(String uiBot) {
        this.uiBot = uiBot;
    }

    public void setIsNavigate(Boolean isNavigate) {
        this.isNavigate = isNavigate;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getDataKey() {
        return this.dataKey;
    }

    public boolean isBusinessKey() {
        return this.businessKey;
    }

    public String getDataType() {
        return this.dataType;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public Precision getPrecision() {
        return this.precision;
    }

    public Object getObjectData() {
        return this.objectData;
    }

    public Boolean getCanSort() {
        return this.canSort;
    }

    public Boolean getCanFilter() {
        return this.canFilter;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public boolean isCanEdit() {
        return this.canEdit;
    }

    public List<MetadataField> getSubFields() {
        return this.subFields;
    }

    public List<MetadataField> getExportTableFields() {
        return this.exportTableFields;
    }

    public boolean isArray() {
        return this.array;
    }

    public String getSourceApi() {
        return this.sourceApi;
    }

    public boolean isHead() {
        return this.isHead;
    }

    public String getClientAgent() {
        return this.clientAgent;
    }

    public String getEnumKey() {
        return this.enumKey;
    }

    public Map<String, MetadataField> getFieldMap() {
        return this.fieldMap;
    }

    public MetadataField getParentField() {
        return this.parentField;
    }

    public String getPercent() {
        return this.percent;
    }

    public Integer getDecimal() {
        return this.decimal;
    }

    public List<GroupMetadataField> getGroupMetadataFields() {
        return this.groupMetadataFields;
    }

    public GroupMetadataField getGroupMetadataField() {
        return this.groupMetadataField;
    }

    public String getUiBot() {
        return this.uiBot;
    }

    public Boolean getIsNavigate() {
        return this.isNavigate;
    }

    public MetadataField(String name, String originalName, String path, boolean required, String description, String remark, String dataKey, boolean businessKey, String dataType, int displayWidth, Precision precision, Object objectData, Boolean canSort, Boolean canFilter, String fieldType, boolean canEdit, List<MetadataField> subFields, List<MetadataField> exportTableFields, boolean array, String sourceApi, boolean isHead, String clientAgent, String enumKey, Map<String, MetadataField> fieldMap, MetadataField parentField, String percent, Integer decimal, List<GroupMetadataField> groupMetadataFields, GroupMetadataField groupMetadataField, String uiBot, Boolean isNavigate) {
        this.name = name;
        this.originalName = originalName;
        this.path = path;
        this.required = required;
        this.description = description;
        this.remark = remark;
        this.dataKey = dataKey;
        this.businessKey = businessKey;
        this.dataType = dataType;
        this.displayWidth = displayWidth;
        this.precision = precision;
        this.objectData = objectData;
        this.canSort = canSort;
        this.canFilter = canFilter;
        this.fieldType = fieldType;
        this.canEdit = canEdit;
        this.subFields = subFields;
        this.exportTableFields = exportTableFields;
        this.array = array;
        this.sourceApi = sourceApi;
        this.isHead = isHead;
        this.clientAgent = clientAgent;
        this.enumKey = enumKey;
        this.fieldMap = fieldMap;
        this.parentField = parentField;
        this.percent = percent;
        this.decimal = decimal;
        this.groupMetadataFields = groupMetadataFields;
        this.groupMetadataField = groupMetadataField;
        this.uiBot = uiBot;
        this.isNavigate = isNavigate;
    }

    public MetadataField() {
    }

    public static class MetadataFieldBuilder {
        private String name;
        private String originalName;
        private String path;
        private boolean required;
        private String description;
        private String remark;
        private String dataKey;
        private boolean businessKey;
        private String dataType;
        private int displayWidth;
        private Precision precision;
        private Object objectData;
        private Boolean canSort;
        private Boolean canFilter;
        private String fieldType;
        private boolean canEdit;
        private List<MetadataField> subFields;
        private List<MetadataField> exportTableFields;
        private boolean array;
        private String sourceApi;
        private boolean isHead;
        private String clientAgent;
        private String enumKey;
        private Map<String, MetadataField> fieldMap;
        private MetadataField parentField;
        private String percent;
        private Integer decimal;
        private List<GroupMetadataField> groupMetadataFields;
        private GroupMetadataField groupMetadataField;
        private String uiBot;
        private Boolean isNavigate;

        MetadataFieldBuilder() {
        }

        public MetadataFieldBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetadataFieldBuilder originalName(String originalName) {
            this.originalName = originalName;
            return this;
        }

        public MetadataFieldBuilder path(String path) {
            this.path = path;
            return this;
        }

        public MetadataFieldBuilder required(boolean required) {
            this.required = required;
            return this;
        }

        public MetadataFieldBuilder description(String description) {
            this.description = description;
            return this;
        }

        public MetadataFieldBuilder remark(String remark) {
            this.remark = remark;
            return this;
        }

        public MetadataFieldBuilder dataKey(String dataKey) {
            this.dataKey = dataKey;
            return this;
        }

        public MetadataFieldBuilder businessKey(boolean businessKey) {
            this.businessKey = businessKey;
            return this;
        }

        public MetadataFieldBuilder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public MetadataFieldBuilder displayWidth(int displayWidth) {
            this.displayWidth = displayWidth;
            return this;
        }

        public MetadataFieldBuilder precision(Precision precision) {
            this.precision = precision;
            return this;
        }

        public MetadataFieldBuilder objectData(Object objectData) {
            this.objectData = objectData;
            return this;
        }

        public MetadataFieldBuilder canSort(Boolean canSort) {
            this.canSort = canSort;
            return this;
        }

        public MetadataFieldBuilder canFilter(Boolean canFilter) {
            this.canFilter = canFilter;
            return this;
        }

        public MetadataFieldBuilder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public MetadataFieldBuilder canEdit(boolean canEdit) {
            this.canEdit = canEdit;
            return this;
        }

        public MetadataFieldBuilder subFields(List<MetadataField> subFields) {
            this.subFields = subFields;
            return this;
        }

        public MetadataFieldBuilder exportTableFields(List<MetadataField> exportTableFields) {
            this.exportTableFields = exportTableFields;
            return this;
        }

        public MetadataFieldBuilder array(boolean array) {
            this.array = array;
            return this;
        }

        public MetadataFieldBuilder sourceApi(String sourceApi) {
            this.sourceApi = sourceApi;
            return this;
        }

        public MetadataFieldBuilder isHead(boolean isHead) {
            this.isHead = isHead;
            return this;
        }

        public MetadataFieldBuilder clientAgent(String clientAgent) {
            this.clientAgent = clientAgent;
            return this;
        }

        public MetadataFieldBuilder enumKey(String enumKey) {
            this.enumKey = enumKey;
            return this;
        }

        public MetadataFieldBuilder fieldMap(Map<String, MetadataField> fieldMap) {
            this.fieldMap = fieldMap;
            return this;
        }

        public MetadataFieldBuilder parentField(MetadataField parentField) {
            this.parentField = parentField;
            return this;
        }

        public MetadataFieldBuilder percent(String percent) {
            this.percent = percent;
            return this;
        }

        public MetadataFieldBuilder decimal(Integer decimal) {
            this.decimal = decimal;
            return this;
        }

        public MetadataFieldBuilder groupMetadataFields(List<GroupMetadataField> groupMetadataFields) {
            this.groupMetadataFields = groupMetadataFields;
            return this;
        }

        public MetadataFieldBuilder groupMetadataField(GroupMetadataField groupMetadataField) {
            this.groupMetadataField = groupMetadataField;
            return this;
        }

        public MetadataFieldBuilder uiBot(String uiBot) {
            this.uiBot = uiBot;
            return this;
        }

        public MetadataFieldBuilder isNavigate(Boolean isNavigate) {
            this.isNavigate = isNavigate;
            return this;
        }

        public MetadataField build() {
            return new MetadataField(this.name, this.originalName, this.path, this.required, this.description, this.remark, this.dataKey, this.businessKey, this.dataType, this.displayWidth, this.precision, this.objectData, this.canSort, this.canFilter, this.fieldType, this.canEdit, this.subFields, this.exportTableFields, this.array, this.sourceApi, this.isHead, this.clientAgent, this.enumKey, this.fieldMap, this.parentField, this.percent, this.decimal, this.groupMetadataFields, this.groupMetadataField, this.uiBot, this.isNavigate);
        }

        public String toString() {
            return "MetadataField.MetadataFieldBuilder(name=" + this.name + ", originalName=" + this.originalName + ", path=" + this.path + ", required=" + this.required + ", description=" + this.description + ", remark=" + this.remark + ", dataKey=" + this.dataKey + ", businessKey=" + this.businessKey + ", dataType=" + this.dataType + ", displayWidth=" + this.displayWidth + ", precision=" + this.precision + ", objectData=" + this.objectData + ", canSort=" + this.canSort + ", canFilter=" + this.canFilter + ", fieldType=" + this.fieldType + ", canEdit=" + this.canEdit + ", subFields=" + this.subFields + ", exportTableFields=" + this.exportTableFields + ", array=" + this.array + ", sourceApi=" + this.sourceApi + ", isHead=" + this.isHead + ", clientAgent=" + this.clientAgent + ", enumKey=" + this.enumKey + ", fieldMap=" + this.fieldMap + ", parentField=" + this.parentField + ", percent=" + this.percent + ", decimal=" + this.decimal + ", groupMetadataFields=" + this.groupMetadataFields + ", groupMetadataField=" + this.groupMetadataField + ", uiBot=" + this.uiBot + ", isNavigate=" + this.isNavigate + ")";
        }
    }
}

