/*
 * Decompiled with CFR 0.152.
 */
package digiwin.chartsdk.utils;

import com.google.gson.Gson;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.Point;
import digiwin.chartsdk.beans.sdk.chart.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.icepear.echarts.Bar;
import org.icepear.echarts.Chart;
import org.icepear.echarts.Line;
import org.icepear.echarts.Option;
import org.icepear.echarts.Pie;
import org.icepear.echarts.charts.bar.BarItemStyle;
import org.icepear.echarts.charts.bar.BarSeries;
import org.icepear.echarts.charts.line.LineSeries;
import org.icepear.echarts.charts.pie.PieSeries;
import org.icepear.echarts.components.legend.Legend;
import org.icepear.echarts.components.title.Title;
import org.icepear.echarts.components.tooltip.Tooltip;
import org.icepear.echarts.origin.chart.bar.BarItemStyleOption;
import org.icepear.echarts.origin.util.SeriesOption;
import org.icepear.echarts.render.Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class ChartUtil {
    private static final Logger log = LoggerFactory.getLogger(ChartUtil.class);

    /*
     * WARNING - void declaration
     */
    public static digiwin.chartsdk.beans.sdk.chart.Option getOption(ChartBase chartBase) {
        void var10_16;
        if (Objects.isNull(chartBase)) {
            return null;
        }
        List<Point> points = chartBase.getPoints();
        List<Value> values = chartBase.getValues();
        List<String> legendList = values.stream().map(Value::getTitle).collect(Collectors.toList());
        String[] legendArray = legendList.toArray(new String[legendList.size()]);
        Legend legend = new Legend();
        legend.setData(legendArray);
        legend.setOrient("horizontal");
        legend.setTop("bottom");
        Title title = new Title();
        title.setText("");
        title.setLeft("left");
        Tooltip tooltip = new Tooltip();
        tooltip.setTrigger("axis");
        ArrayList pointNameList = new ArrayList();
        for (Point point : points) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map<String, Object> map : chartBase.getDatas()) {
                String string = (String)map.get(point.getName());
                arrayList.add(string);
            }
            pointNameList.add(arrayList);
        }
        ArrayList valueNameList = new ArrayList();
        for (Value value : values) {
            ArrayList<String> names = new ArrayList<String>();
            for (Map<String, Object> map : chartBase.getDatas()) {
                String date = String.valueOf(map.get(value.getName()));
                names.add(date);
            }
            valueNameList.add(names);
        }
        String string = "";
        switch (chartBase.getType()) {
            case "line": {
                void var14_33;
                Line line = (Line)((Line)((Line)((Line)new Line().addYAxis()).setLegend(legend)).setTitle(title)).setTooltip(tooltip);
                boolean bl = false;
                while (var14_33 < pointNameList.size()) {
                    line.addXAxis(((List)pointNameList.get((int)var14_33)).toArray(new String[((List)pointNameList.get((int)var14_33)).size()]));
                    ++var14_33;
                }
                if (CollectionUtils.isNotEmpty(valueNameList) && valueNameList.size() == 1) {
                    LineSeries lineSeries = new LineSeries();
                    lineSeries.setSmooth(Boolean.valueOf(true));
                    lineSeries.setName((String)legendList.get(0));
                    lineSeries.setData((Object[])((List)valueNameList.get(0)).toArray(new String[((List)valueNameList.get(0)).size()]));
                    lineSeries.setColor(ChartUtil.getColorList().get(0));
                    line.addSeries((SeriesOption)lineSeries);
                } else {
                    List<String> list = ChartUtil.getColorList();
                    if (valueNameList.size() > ChartUtil.getColorList().size()) {
                        List<String> list2 = ChartUtil.getRandomRGB(ChartUtil.getColorList(), valueNameList.size());
                    }
                    for (int i = 0; i < valueNameList.size(); ++i) {
                        void var14_37;
                        LineSeries lineSeries = new LineSeries();
                        lineSeries.setSmooth(Boolean.valueOf(true));
                        lineSeries.setName((String)legendList.get(i));
                        lineSeries.setData((Object[])((List)valueNameList.get(i)).toArray(new String[((List)valueNameList.get(i)).size()]));
                        lineSeries.setColor((String)var14_37.get(i));
                        line.addSeries((SeriesOption)lineSeries);
                    }
                }
                Engine engine = new Engine();
                String string2 = engine.renderJsonOption((Chart)line);
                break;
            }
            case "bar": {
                Bar barChart = (Bar)((Bar)((Bar)((Bar)new Bar().addYAxis()).setLegend(legend)).setTitle(title)).setTooltip(tooltip);
                for (int i = 0; i < pointNameList.size(); ++i) {
                    barChart.addXAxis(((List)pointNameList.get(i)).toArray(new String[((List)pointNameList.get(i)).size()]));
                }
                if (CollectionUtils.isNotEmpty(valueNameList) && valueNameList.size() == 1) {
                    BarSeries barSeries = new BarSeries();
                    barSeries.setName((String)legendList.get(0));
                    barSeries.setData(((List)valueNameList.get(0)).toArray(new String[((List)valueNameList.get(0)).size()]));
                    barSeries.setBarWidth((Number)15);
                    BarItemStyle barItemStyle = new BarItemStyle();
                    barItemStyle.setBorderRadius((Number[])new Integer[]{3, 3, 3, 3});
                    barSeries.setItemStyle((BarItemStyleOption)barItemStyle);
                    barSeries.setColor(ChartUtil.getColorList().get(0));
                    barChart.addSeries((SeriesOption)barSeries);
                } else {
                    List<String> randomRGB = ChartUtil.getColorList();
                    if (valueNameList.size() > ChartUtil.getColorList().size()) {
                        randomRGB = ChartUtil.getRandomRGB(ChartUtil.getColorList(), valueNameList.size());
                    }
                    for (int i = 0; i < valueNameList.size(); ++i) {
                        BarSeries barSeries = new BarSeries();
                        barSeries.setName((String)legendList.get(i));
                        barSeries.setData(((List)valueNameList.get(i)).toArray(new String[((List)valueNameList.get(i)).size()]));
                        barSeries.setBarWidth((Number)15);
                        BarItemStyle barItemStyle = new BarItemStyle();
                        barItemStyle.setBorderRadius((Number[])new Integer[]{3, 3, 3, 3});
                        barSeries.setItemStyle((BarItemStyleOption)barItemStyle);
                        barSeries.setColor(randomRGB.get(i));
                        barChart.addSeries((SeriesOption)barSeries);
                    }
                }
                Engine engineBar = new Engine();
                String string3 = engineBar.renderJsonOption((Chart)barChart);
                break;
            }
            case "pie": {
                Object o;
                tooltip = new Tooltip();
                tooltip.setTrigger("item");
                tooltip.setFormatter("{a} <br/>{b}: {c} ({d}%)");
                legend = new Legend();
                legend.setOrient("horizontal");
                legend.setTop("bottom");
                title = new Title();
                title.setText("");
                title.setLeft("left");
                Pie pieChart = (Pie)((Pie)((Pie)new Pie().setLegend(legend)).setTitle(title)).setTooltip(tooltip);
                List collectPointName = points.stream().map(Point::getName).collect(Collectors.toList());
                List collectValueName = values.stream().map(Value::getName).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collectPointName) && CollectionUtils.isNotEmpty(collectValueName) && collectPointName.size() == 1 && collectValueName.size() == 1) {
                    void var22_57;
                    ArrayList seriesListMap = new ArrayList();
                    for (Map<String, Object> map : chartBase.getDatas()) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        o = map.get(collectPointName.get(0));
                        hashMap.put("name", o);
                        Object o1 = map.get(collectValueName.get(0));
                        hashMap.put("value", o1);
                        seriesListMap.add(hashMap);
                    }
                    PieSeries pieSeries = new PieSeries();
                    pieSeries.setData(seriesListMap).setRadius("50%").setType("pie").setName((String)legendList.get(0));
                    List<String> list = ChartUtil.getColorList();
                    if (seriesListMap.size() > ChartUtil.getColorList().size()) {
                        List<String> list3 = ChartUtil.getRandomRGB(ChartUtil.getColorList(), seriesListMap.size());
                    }
                    pieSeries.setColor(var22_57.toArray(new String[seriesListMap.size()]));
                    pieChart.addSeries((SeriesOption)pieSeries);
                }
                if (CollectionUtils.isNotEmpty(collectPointName) && CollectionUtils.isNotEmpty(collectValueName) && collectPointName.size() > 1) {
                    void var23_71;
                    void var23_69;
                    HashMap<Object, Double> valuesSeries = new HashMap<Object, Double>();
                    for (Map<String, Object> map : chartBase.getDatas()) {
                        HashMap hashMap = new HashMap();
                        o = map.get(collectPointName.get(0));
                        Double purchaseSum = null;
                        try {
                            purchaseSum = (Double)map.get(collectValueName.get(0));
                        }
                        catch (Exception e) {
                            log.info("\u7ed3\u679c\uff1a" + map.get(collectValueName.get(0)) + "\uff0c\u65e0\u6cd5\u5f3a\u8f6c\u4e3aDouble");
                            Integer integerValue = (Integer)map.get(collectValueName.get(0));
                            purchaseSum = integerValue.doubleValue();
                        }
                        if (valuesSeries.containsKey(o)) {
                            double currentSum = (Double)valuesSeries.get(o);
                            valuesSeries.put(o, currentSum + purchaseSum);
                            continue;
                        }
                        valuesSeries.put(o, purchaseSum);
                    }
                    ArrayList seriesListMap2 = new ArrayList();
                    for (Map.Entry entry : valuesSeries.entrySet()) {
                        HashMap<String, Object> map2 = new HashMap<String, Object>();
                        map2.put("name", entry.getKey());
                        map2.put("value", entry.getValue());
                        seriesListMap2.add(map2);
                    }
                    PieSeries pieSeries = new PieSeries();
                    pieSeries.setData(seriesListMap2).setRadius(new String[]{"0", "30%"}).setType("pie").setName((String)legendList.get(0));
                    List<String> list = ChartUtil.getColorList();
                    if (seriesListMap2.size() > ChartUtil.getColorList().size()) {
                        List<String> list4 = ChartUtil.getRandomRGB(ChartUtil.getColorList(), seriesListMap2.size());
                    }
                    List list5 = var23_69.subList(0, seriesListMap2.size());
                    pieSeries.setColor(list5.toArray(new String[seriesListMap2.size()]));
                    pieChart.addSeries((SeriesOption)pieSeries);
                    ArrayList seriesListMap = new ArrayList();
                    for (Map<String, Object> datas : chartBase.getDatas()) {
                        HashMap<String, Object> map3 = new HashMap<String, Object>();
                        Object object = datas.get(collectPointName.get(collectPointName.size() - 1));
                        map3.put("name", object);
                        Object o1 = datas.get(collectValueName.get(0));
                        map3.put("value", o1);
                        seriesListMap.add(map3);
                    }
                    PieSeries pieSeries2 = new PieSeries();
                    pieSeries2.setData(seriesListMap).setRadius(new String[]{"45%", "60%"}).setType("pie").setName((String)legendList.get(0));
                    var23_69.subList(0, seriesListMap2.size()).clear();
                    HashMap<String, Integer> groupCounts = new HashMap<String, Integer>();
                    for (Map map : seriesListMap) {
                        String name = (String)map.get("name");
                        groupCounts.put(name, groupCounts.getOrDefault(name, 0) + 1);
                    }
                    int numGroups = groupCounts.size();
                    if (numGroups > var23_69.size()) {
                        List<String> list6 = ChartUtil.getRandomRGB(ChartUtil.getColorList(), numGroups);
                    }
                    List list7 = var23_71.subList(0, numGroups);
                    pieSeries2.setColor(list7.toArray(new String[numGroups]));
                    pieChart.addSeries((SeriesOption)pieSeries2);
                }
                Engine enginePie = new Engine();
                String string4 = enginePie.renderJsonOption((Chart)pieChart);
                break;
            }
        }
        Option option = (Option)new Gson().fromJson((String)var10_16, Option.class);
        digiwin.chartsdk.beans.sdk.chart.Option option1 = new digiwin.chartsdk.beans.sdk.chart.Option();
        BeanUtils.copyProperties((Object)option, (Object)option1);
        return option1;
    }

    public static List<String> getRandomRGB(List<String> colors, Integer size) {
        ArrayList<String> result = new ArrayList<String>();
        if (colors != null && !colors.isEmpty()) {
            result.addAll(colors);
        }
        if (result.size() >= size) {
            return result;
        }
        HashSet<String> colorSet = new HashSet<String>(result);
        while (result.size() < size) {
            Random random = new Random();
            String colorHex = String.format("#%06x", random.nextInt(0x1000000));
            int r = Integer.parseInt(colorHex.substring(1, 3), 16);
            int g = Integer.parseInt(colorHex.substring(3, 5), 16);
            int b = Integer.parseInt(colorHex.substring(5, 7), 16);
            String color = String.format("#%02x%02x%02x", r, g, b).toUpperCase();
            if (!colorSet.add(color)) continue;
            result.add(color);
        }
        return result;
    }

    public static List<String> getColorList() {
        ArrayList<String> colorList = new ArrayList<String>();
        colorList.add("#4248F4");
        colorList.add("#2EBF9D");
        colorList.add("#8A46E2");
        colorList.add("#F0C100");
        colorList.add("#3ACCEF");
        colorList.add("#F0A223");
        colorList.add("#FA6E74");
        colorList.add("#E144CF");
        return colorList;
    }
}

