/*
 * Decompiled with CFR 0.152.
 */
package digiwin.chartsdk.utils;

import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.ChartBaseSeries;
import digiwin.chartsdk.beans.sdk.chart.ChartFormat;
import digiwin.chartsdk.beans.sdk.chart.ChartLegend;
import digiwin.chartsdk.beans.sdk.chart.ChartMultiValue;
import digiwin.chartsdk.beans.sdk.chart.ChartScatterSeries;
import digiwin.chartsdk.beans.sdk.chart.ChartValue;
import digiwin.chartsdk.beans.sdk.chart.ChartValueAxis;
import digiwin.chartsdk.beans.sdk.chart.Point;
import digiwin.chartsdk.beans.sdk.chart.Value;
import digiwin.chartsdk.utils.ChartDataQuery;
import digiwin.chartsdk.utils.ChartDataUtils;
import digiwin.chartsdk.utils.ChartGraphBase;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.icepear.echarts.Chart;
import org.icepear.echarts.Scatter;
import org.icepear.echarts.components.legend.Legend;
import org.icepear.echarts.origin.coord.cartesian.AxisOption;
import org.icepear.echarts.origin.util.SeriesOption;

public class ChartScatter
extends ChartGraphBase {
    public static Chart getChart(ChartBase chartBase, ChartBaseSeries chartBaseSeries) {
        List<Point> points = chartBaseSeries.getPoints();
        Point mainPoint = null;
        Point otherPoint = null;
        if (points.size() > 0) {
            for (Point point2 : points) {
                List<String> data = ChartDataQuery.getChartData(chartBase, point2.getName());
                if (!CollectionUtils.isNotEmpty(data) || (data = data.stream().distinct().collect(Collectors.toList())).size() >= 20) continue;
                mainPoint = point2;
                break;
            }
            if (mainPoint == null) {
                mainPoint = points.get(0);
            } else {
                Point finalMainPoint = mainPoint;
                otherPoint = points.stream().filter(point -> !point.getName().equals(finalMainPoint.getName())).findFirst().orElse(null);
            }
        }
        ChartValue xValue = new ChartValue();
        ChartValue yValue = new ChartValue();
        if (chartBaseSeries.getValues().size() > 1) {
            Value value1 = chartBaseSeries.getValues().get(0);
            xValue.setDecimal(value1.getDecimal());
            xValue.setPercent(value1.getPercent());
            xValue.setDecimalRule(value1.getDecimalRule());
            xValue.setUnit(value1.getUnit());
            xValue.setMarkLine(value1.getMarkLine());
            xValue.setExtendInfo(value1.getExtendInfo());
            xValue.setTitle(value1.getTitle());
            xValue.setName(value1.getName());
            Value value2 = chartBaseSeries.getValues().get(1);
            yValue.setDecimal(value2.getDecimal());
            yValue.setPercent(value2.getPercent());
            yValue.setDecimalRule(value2.getDecimalRule());
            yValue.setUnit(value2.getUnit());
            yValue.setMarkLine(value2.getMarkLine());
            yValue.setExtendInfo(value2.getExtendInfo());
            yValue.setTitle(value2.getTitle());
            yValue.setName(value2.getName());
        }
        ChartLegend legend = ChartGraphBase.getLegend();
        List<String> data = ChartDataQuery.getChartData(chartBase, mainPoint.getName());
        data = data.stream().distinct().collect(Collectors.toList());
        String[] legendArray = data.toArray(new String[data.size()]);
        legend.setData(legendArray);
        Point finalPoint = mainPoint;
        Map groupMap = chartBase.getDatas().stream().collect(Collectors.groupingBy(map -> String.valueOf(map.get(finalPoint.getName())), LinkedHashMap::new, Collectors.toList()));
        ArrayList<ChartMultiValue> chartMultiValues = new ArrayList<ChartMultiValue>();
        if (MapUtils.isNotEmpty((Map)groupMap)) {
            for (Map.Entry entry : groupMap.entrySet()) {
                ChartMultiValue chartMultiValue = new ChartMultiValue();
                chartMultiValue.setTitle((String)entry.getKey());
                chartMultiValue.setValues((List)entry.getValue());
                chartMultiValue.setMainPoint(mainPoint);
                chartMultiValue.setOtherPoint(otherPoint);
                chartMultiValue.setXValue(xValue);
                chartMultiValue.setYValue(yValue);
                chartMultiValues.add(chartMultiValue);
            }
        }
        return ChartScatter.getScatter(legend, chartMultiValues, xValue, yValue);
    }

    private static Scatter getScatter(Legend legend, List<ChartMultiValue> chartMultiValues, ChartValue xValue, ChartValue yValue) {
        Scatter scatter = (Scatter)new Scatter().setLegend(legend);
        ChartValueAxis axis = new ChartValueAxis();
        if (xValue != null) {
            ChartFormat xFormat = new ChartFormat();
            xFormat.setDecimal(xValue.getDecimal());
            xFormat.setPercent(xValue.getPercent());
            xFormat.setDecimalRule(xValue.getDecimalRule());
            xFormat.setUnit(xValue.getUnit());
            axis.setFormat(xFormat);
            axis.setExtendInfo(xValue.getExtendInfo());
            axis.setName(xValue.getTitle());
        }
        scatter.addXAxis((AxisOption)axis);
        ChartValueAxis yxis = new ChartValueAxis();
        if (yValue != null) {
            ChartFormat yFormat = new ChartFormat();
            yFormat.setDecimal(yValue.getDecimal());
            yFormat.setPercent(yValue.getPercent());
            yFormat.setDecimalRule(yValue.getDecimalRule());
            yFormat.setUnit(yValue.getUnit());
            yxis.setFormat(yFormat);
            yxis.setExtendInfo(yValue.getExtendInfo());
            yxis.setName(yValue.getTitle());
        }
        scatter.addYAxis((AxisOption)yxis);
        for (int i = 0; i < chartMultiValues.size(); ++i) {
            ChartMultiValue chartMultiValue = chartMultiValues.get(i);
            ChartScatterSeries scatterSeries = new ChartScatterSeries();
            scatterSeries.setName(chartMultiValue.getTitle());
            int dataIndex = 2;
            if (chartMultiValue.getOtherPoint() != null) {
                scatterSeries.setDimensionSize(2);
                dataIndex = 3;
            }
            Object[][] datas = new Object[chartMultiValue.getValues().size()][dataIndex];
            List<Map<String, Object>> values = chartMultiValue.getValues();
            for (int j = 0; j < values.size(); ++j) {
                Map<String, Object> value = values.get(j);
                if (chartMultiValue.getXValue() != null) {
                    datas[j][0] = ChartDataUtils.getChartData(MapUtils.getObject(value, (Object)chartMultiValue.getXValue().getName(), null));
                }
                if (chartMultiValue.getYValue() != null) {
                    datas[j][1] = ChartDataUtils.getChartData(MapUtils.getObject(value, (Object)chartMultiValue.getYValue().getName(), null));
                }
                if (chartMultiValue.getOtherPoint() == null) continue;
                datas[j][2] = ChartDataUtils.getChartData(MapUtils.getObject(value, (Object)chartMultiValue.getOtherPoint().getName(), null));
            }
            scatterSeries.setData(datas);
            scatter.addSeries((SeriesOption)scatterSeries);
        }
        return scatter;
    }
}

