/*
 * Decompiled with CFR 0.152.
 */
package digiwin.chartsdk.utils;

import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.ChartBaseSeries;
import digiwin.chartsdk.beans.sdk.chart.ChartDataMetric;
import digiwin.chartsdk.beans.sdk.chart.ChartFormat;
import digiwin.chartsdk.beans.sdk.chart.ChartPieData;
import digiwin.chartsdk.beans.sdk.chart.ChartPieSeries;
import digiwin.chartsdk.beans.sdk.chart.Point;
import digiwin.chartsdk.beans.sdk.chart.Value;
import digiwin.chartsdk.utils.ChartDataUtils;
import digiwin.chartsdk.utils.ChartGraphBase;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.icepear.echarts.Chart;
import org.icepear.echarts.Pie;
import org.icepear.echarts.origin.util.SeriesOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ChartPie
extends ChartGraphBase {
    private static final Logger log = LoggerFactory.getLogger(ChartPie.class);

    public static Chart getChart(ChartBase chartBase, ChartBaseSeries chartBaseSeries) {
        List<Point> points = chartBaseSeries.getPoints();
        List<Value> values = chartBaseSeries.getValues();
        return ChartPie.getPie(chartBase, points, values);
    }

    private static Pie getPie(ChartBase chartBase, List<Point> points, List<Value> values) {
        Pie pieChart = new Pie();
        Point point = new Point();
        if (CollectionUtils.isNotEmpty(points)) {
            point = points.get(0);
        }
        Value value = new Value();
        if (CollectionUtils.isNotEmpty(values)) {
            value = values.get(0);
        }
        if (CollectionUtils.isNotEmpty(points) && CollectionUtils.isNotEmpty(values)) {
            HashMap<Object, ChartPieData> valuesSeries = new HashMap<Object, ChartPieData>();
            for (Map<String, Object> data : chartBase.getDatas()) {
                Object showName = data.get(point.getName());
                Object showValue = data.get(value.getName());
                ChartPieData chartPieData = new ChartPieData();
                Double purchaseSum = null;
                try {
                    BigDecimal bigDecimalValue = new BigDecimal(showValue.toString());
                    purchaseSum = bigDecimalValue.doubleValue();
                }
                catch (Exception e) {
                    log.info("\u7ed3\u679c\uff1a" + showValue + "\uff0c\u65e0\u6cd5\u5f3a\u8f6c\u4e3aDouble");
                    Integer integerValue = (Integer)showValue;
                    purchaseSum = integerValue.doubleValue();
                }
                if (valuesSeries.containsKey(showName)) {
                    ChartPieData sumData = (ChartPieData)valuesSeries.get(showName);
                    double currentSum = (Double)sumData.getValue();
                    chartPieData.setValue(currentSum + purchaseSum);
                } else {
                    chartPieData.setValue(purchaseSum);
                }
                chartPieData.setDimensionData(Arrays.asList(new ChartDataMetric(point.getTitle(), showName)));
                chartPieData.setMeasurementData(Arrays.asList(new ChartDataMetric(value.getTitle(), ChartDataUtils.getChartData(chartPieData.getValue()))));
                valuesSeries.put(showName, chartPieData);
            }
            List valuesSeriesList = valuesSeries.entrySet().stream().map(x -> {
                HashMap<String, Object> series = new HashMap<String, Object>();
                series.put("name", x.getKey());
                ChartPieData chartPieData = (ChartPieData)x.getValue();
                series.put("value", chartPieData.getValue());
                series.put("dimensionData", chartPieData.getDimensionData());
                series.put("measurementData", chartPieData.getMeasurementData());
                return series;
            }).collect(Collectors.toList());
            ChartFormat chartFormat = new ChartFormat();
            chartFormat.setDecimal(value.getDecimal());
            chartFormat.setPercent(value.getPercent());
            chartFormat.setDecimalRule(value.getDecimalRule());
            chartFormat.setUnit(value.getUnit());
            ChartPieSeries pieSeries = new ChartPieSeries();
            pieSeries.setFormat(chartFormat);
            pieSeries.setData(valuesSeriesList);
            pieSeries.setExtendInfo(value.getExtendInfo());
            pieChart.addSeries((SeriesOption)pieSeries);
        }
        return pieChart;
    }
}

