/*
 * Decompiled with CFR 0.152.
 */
package digiwin.chartsdk.utils;

import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.ChartBaseSeries;
import digiwin.chartsdk.beans.sdk.chart.ChartFormat;
import digiwin.chartsdk.beans.sdk.chart.ChartLegend;
import digiwin.chartsdk.beans.sdk.chart.ChartMultiValue;
import digiwin.chartsdk.beans.sdk.chart.ChartScatterSeries;
import digiwin.chartsdk.beans.sdk.chart.ChartValue;
import digiwin.chartsdk.beans.sdk.chart.ChartValueAxis;
import digiwin.chartsdk.beans.sdk.chart.DefineScatter;
import digiwin.chartsdk.beans.sdk.chart.Point;
import digiwin.chartsdk.beans.sdk.chart.Value;
import digiwin.chartsdk.utils.ChartAttributes;
import digiwin.chartsdk.utils.ChartDataQuery;
import digiwin.chartsdk.utils.ChartDataUtils;
import digiwin.chartsdk.utils.ChartGraphBase;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.icepear.echarts.Chart;
import org.icepear.echarts.components.legend.Legend;
import org.icepear.echarts.origin.coord.cartesian.AxisOption;
import org.icepear.echarts.origin.util.SeriesOption;

public class ChartScatter
extends ChartGraphBase {
    public static Chart getChart(ChartBase chartBase, ChartBaseSeries chartBaseSeries) {
        String[] legendArray;
        List<Point> points = chartBaseSeries.getPoints();
        Point mainPoint = null;
        Point otherPoint = null;
        if (points.size() > 0) {
            Point finalMainPoint = mainPoint = points.get(0);
            otherPoint = points.stream().filter(point -> !point.getName().equals(finalMainPoint.getName())).findFirst().orElse(null);
        }
        Integer dimensionSize = 1;
        if (otherPoint != null) {
            dimensionSize = 2;
        }
        ChartValue xValue = new ChartValue();
        ChartValue yValue = new ChartValue();
        if (chartBaseSeries.getValues().size() > 1) {
            Value value1 = chartBaseSeries.getValues().get(0);
            xValue.setDecimal(value1.getDecimal());
            xValue.setPercent(value1.getPercent());
            xValue.setDecimalRule(value1.getDecimalRule());
            xValue.setUnit(value1.getUnit());
            xValue.setMarkLine(value1.getMarkLine());
            xValue.setExtendInfo(value1.getExtendInfo());
            xValue.setTitle(value1.getTitle());
            xValue.setName(value1.getName());
            Value value2 = chartBaseSeries.getValues().get(1);
            yValue.setDecimal(value2.getDecimal());
            yValue.setPercent(value2.getPercent());
            yValue.setDecimalRule(value2.getDecimalRule());
            yValue.setUnit(value2.getUnit());
            yValue.setMarkLine(value2.getMarkLine());
            yValue.setExtendInfo(value2.getExtendInfo());
            yValue.setTitle(value2.getTitle());
            yValue.setName(value2.getName());
        }
        ChartLegend legend = ChartGraphBase.getLegend();
        List<String> data = ChartDataQuery.getChartData(chartBase, mainPoint.getName());
        data = data.stream().distinct().collect(Collectors.toList());
        data = ChartAttributes.sortFiled(data, mainPoint.getSort(), mainPoint.getIsTime());
        ArrayList<ChartMultiValue> chartMultiValues = new ArrayList<ChartMultiValue>();
        Map<String, List<Map<String, Object>>> groupMap = new HashMap<String, List<Map<String, Object>>>();
        if (points.size() > 1) {
            legendArray = data.toArray(new String[data.size()]);
            legend.setData(legendArray);
            Point finalPoint = mainPoint;
            List<String> finalData = data;
            groupMap = chartBase.getDatas().stream().collect(Collectors.groupingBy(map -> String.valueOf(map.get(finalPoint.getName())), LinkedHashMap::new, Collectors.toList())).entrySet().stream().sorted(Comparator.comparingInt(e -> {
                int index = finalData.indexOf(e.getKey());
                return index == -1 ? Integer.MAX_VALUE : index;
            })).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        } else {
            legendArray = new String[1];
            otherPoint = mainPoint;
            legendArray[0] = mainPoint.getTitle();
            legend.setData(legendArray);
            groupMap.put(mainPoint.getTitle(), chartBase.getDatas());
        }
        if (MapUtils.isNotEmpty(groupMap)) {
            for (Map.Entry entry : groupMap.entrySet()) {
                ChartMultiValue chartMultiValue = new ChartMultiValue();
                chartMultiValue.setTitle((String)entry.getKey());
                chartMultiValue.setValues((List)entry.getValue());
                chartMultiValue.setMainPoint(mainPoint);
                chartMultiValue.setOtherPoint(otherPoint);
                chartMultiValue.setXValue(xValue);
                chartMultiValue.setYValue(yValue);
                chartMultiValues.add(chartMultiValue);
            }
        }
        return ChartScatter.getScatter(legend, chartMultiValues, xValue, yValue, dimensionSize);
    }

    private static DefineScatter getScatter(Legend legend, List<ChartMultiValue> chartMultiValues, ChartValue xValue, ChartValue yValue, Integer dimensionSize) {
        DefineScatter scatter = new DefineScatter();
        scatter.setLegend(legend);
        ArrayList<Map<String, Object>> schemaList = new ArrayList<Map<String, Object>>();
        scatter.setSchema(schemaList);
        ChartValueAxis axis = new ChartValueAxis();
        if (xValue != null) {
            ChartFormat xFormat = new ChartFormat();
            xFormat.setDecimal(xValue.getDecimal());
            xFormat.setPercent(xValue.getPercent());
            xFormat.setDecimalRule(xValue.getDecimalRule());
            xFormat.setUnit(xValue.getUnit());
            axis.setFormat(xFormat);
            axis.setExtendInfo(xValue.getExtendInfo());
            axis.setName(xValue.getTitle());
            HashMap<String, Object> xMap = new HashMap<String, Object>();
            xMap.put("name", xValue.getTitle());
            xMap.put("index", 0);
            xMap.put("format", xFormat);
            schemaList.add(xMap);
        }
        scatter.addXAxis((AxisOption)axis);
        ChartValueAxis yxis = new ChartValueAxis();
        if (yValue != null) {
            ChartFormat yFormat = new ChartFormat();
            yFormat.setDecimal(yValue.getDecimal());
            yFormat.setPercent(yValue.getPercent());
            yFormat.setDecimalRule(yValue.getDecimalRule());
            yFormat.setUnit(yValue.getUnit());
            yxis.setFormat(yFormat);
            yxis.setExtendInfo(yValue.getExtendInfo());
            yxis.setName(yValue.getTitle());
            HashMap<String, Object> yMap = new HashMap<String, Object>();
            yMap.put("name", yValue.getTitle());
            yMap.put("index", 1);
            yMap.put("format", yFormat);
            schemaList.add(yMap);
        }
        scatter.addYAxis((AxisOption)yxis);
        Point point = null;
        for (int i = 0; i < chartMultiValues.size(); ++i) {
            ChartMultiValue chartMultiValue = chartMultiValues.get(i);
            ChartScatterSeries scatterSeries = new ChartScatterSeries();
            scatterSeries.setName(chartMultiValue.getTitle());
            int dataIndex = 2;
            scatterSeries.setDimensionSize(dimensionSize);
            if (chartMultiValue.getOtherPoint() != null) {
                dataIndex = 3;
            }
            Object[][] datas = new Object[chartMultiValue.getValues().size()][dataIndex];
            List<Map<String, Object>> values = chartMultiValue.getValues();
            for (int j = 0; j < values.size(); ++j) {
                Map<String, Object> value = values.get(j);
                if (chartMultiValue.getXValue() != null) {
                    datas[j][0] = ChartDataUtils.getChartData(MapUtils.getObject(value, (Object)chartMultiValue.getXValue().getName(), null));
                }
                if (chartMultiValue.getYValue() != null) {
                    datas[j][1] = ChartDataUtils.getChartData(MapUtils.getObject(value, (Object)chartMultiValue.getYValue().getName(), null));
                }
                if (chartMultiValue.getOtherPoint() == null) continue;
                point = chartMultiValue.getOtherPoint();
                datas[j][2] = ChartDataUtils.getChartData(MapUtils.getObject(value, (Object)chartMultiValue.getOtherPoint().getName(), null));
            }
            scatterSeries.setData(datas);
            scatter.addSeries((SeriesOption)scatterSeries);
        }
        if (point != null) {
            HashMap<String, Object> pointMap = new HashMap<String, Object>();
            pointMap.put("name", point.getTitle());
            pointMap.put("index", 2);
            schemaList.add(pointMap);
        }
        return scatter;
    }
}

