/*
 * Decompiled with CFR 0.152.
 */
package digiwin.chartsdk.utils;

import digiwin.chartsdk.beans.sdk.chart.ChartBarSeries;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.ChartBaseSeries;
import digiwin.chartsdk.beans.sdk.chart.ChartFormat;
import digiwin.chartsdk.beans.sdk.chart.ChartLegend;
import digiwin.chartsdk.beans.sdk.chart.ChartMarkPoint;
import digiwin.chartsdk.beans.sdk.chart.ChartTooltip;
import digiwin.chartsdk.beans.sdk.chart.ChartValue;
import digiwin.chartsdk.beans.sdk.chart.ChartValueAxis;
import digiwin.chartsdk.beans.sdk.chart.Point;
import digiwin.chartsdk.beans.sdk.chart.Value;
import digiwin.chartsdk.utils.ChartAttributes;
import digiwin.chartsdk.utils.ChartGraphBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.icepear.echarts.Bar;
import org.icepear.echarts.Chart;
import org.icepear.echarts.components.legend.Legend;
import org.icepear.echarts.components.title.Title;
import org.icepear.echarts.origin.component.marker.MarkPointOption;
import org.icepear.echarts.origin.coord.cartesian.AxisOption;
import org.icepear.echarts.origin.util.SeriesOption;
import org.springframework.stereotype.Component;

@Component
public class ChartLineBar
extends ChartGraphBase {
    public static Chart getChart(ChartBase chartBase, ChartBaseSeries chartBaseSeries) {
        List<Point> points = chartBaseSeries.getPoints();
        List<Value> values = chartBaseSeries.getValues();
        ChartLegend legend = ChartGraphBase.getLegend();
        List<String> legendList = chartBaseSeries.getValues().stream().map(Value::getTitle).collect(Collectors.toList());
        String[] legendArray = legendList.toArray(new String[legendList.size()]);
        legend.setData(legendArray);
        ArrayList<List<String>> pointNameList = new ArrayList<List<String>>();
        for (Point pointField : points) {
            ArrayList<String> names = new ArrayList<String>();
            for (Map<String, Object> map : chartBase.getDatas()) {
                String date = String.valueOf(map.get(pointField.getName()));
                names.add(date);
            }
            pointNameList.add(names);
        }
        ArrayList<ChartValue> valueNameList = new ArrayList<ChartValue>();
        for (Value valueField : values) {
            ChartValue chartValue = new ChartValue();
            ChartAttributes.fillAnalysis(chartBase, valueField, chartValue, points.get(0));
            chartValue.setDecimal(valueField.getDecimal());
            chartValue.setPercent(valueField.getPercent());
            chartValue.setDecimalRule(valueField.getDecimalRule());
            chartValue.setUnit(valueField.getUnit());
            chartValue.setPointName(valueField.getPointName());
            chartValue.setExtendInfo(valueField.getExtendInfo());
            if (chartBase.getCube() != null) {
                chartValue.setCube(chartBase.getCube());
            }
            valueNameList.add(chartValue);
        }
        return ChartLineBar.getLineBar(legend, null, null, pointNameList, valueNameList, legendList, chartBase);
    }

    private static Bar getLineBar(Legend legend, Title title, ChartTooltip tooltip, List<List<String>> pointNameList, List<ChartValue> valueNameList, List<String> legendList, ChartBase chartBase) {
        int i;
        Bar barChart = (Bar)new Bar().setLegend(legend);
        ChartFormat format = new ChartFormat();
        for (i = 0; i < pointNameList.size(); ++i) {
            barChart.addYAxis(pointNameList.get(i).toArray(new String[pointNameList.get(i).size()]));
        }
        for (i = 0; i < valueNameList.size(); ++i) {
            ChartValue chartValue = valueNameList.get(i);
            ChartBarSeries barSeries = new ChartBarSeries();
            barSeries.setName(legendList.get(i));
            barSeries.setData(chartValue.getValues());
            format.setDecimal(chartValue.getDecimal());
            format.setPercent(chartValue.getPercent());
            format.setDecimalRule(chartValue.getDecimalRule());
            format.setUnit(chartValue.getUnit());
            barSeries.setFormat(format);
            barSeries.setExtendInfo(chartValue.getExtendInfo());
            if (chartValue.getPointName() != null && CollectionUtils.isNotEmpty(chartValue.getPointName().getPointValues())) {
                ChartMarkPoint markPointOption = new ChartMarkPoint();
                markPointOption.setFormat(chartValue.getPointName().getFormat());
                markPointOption.setData(chartValue.getPointName().getPointValues().toArray());
                barSeries.setMarkPoint((MarkPointOption)markPointOption);
            }
            barChart.addSeries((SeriesOption)barSeries);
        }
        ChartValueAxis yAxis = new ChartValueAxis();
        yAxis.setFormat(format);
        barChart.addXAxis((AxisOption)yAxis);
        return barChart;
    }
}

