/*
 * Decompiled with CFR 0.152.
 */
package digiwin.chartsdk.utils;

import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.ChartDataMetric;
import digiwin.chartsdk.beans.sdk.chart.ChartValue;
import digiwin.chartsdk.beans.sdk.chart.Point;
import digiwin.chartsdk.beans.sdk.chart.Value;
import digiwin.chartsdk.utils.ChartDataUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class ChartAttributes {
    private static final List<String> GRAIN_NAME = Arrays.asList("\u5e74", "\u6708", "\u65e5", "\u5468", "\u5b63\u5ea6", "\u9031", "\u5b63");

    public static void fillAnalysis(ChartBase chartBase, Value value, ChartValue chartValue, Point point) {
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : chartBase.getDatas()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("value", ChartDataUtils.getChartData(map.get(value.getName())));
            ArrayList<ChartDataMetric> dimensionData = new ArrayList<ChartDataMetric>();
            List<ChartDataMetric> measurementData = new ArrayList<ChartDataMetric>();
            ChartDataMetric dataMetric = new ChartDataMetric(point.getTitle(), point.getName(), point.getName(), map.get(point.getName()));
            dimensionData.add(dataMetric);
            if (CollectionUtils.isNotEmpty(value.getDimensionValue())) {
                dimensionData.addAll(ChartAttributes.getDataMetric(value.getDimensionValue(), map));
            }
            if (CollectionUtils.isNotEmpty(value.getMeasurementValue())) {
                measurementData = ChartAttributes.getDataMetric(value.getMeasurementValue(), map);
            } else {
                measurementData.add(new ChartDataMetric(value.getTitle(), value.getName(), value.getOriginalName(), map.get(value.getName())));
            }
            data.put("dimensionData", dimensionData);
            data.put("measurementData", measurementData);
            if (chartBase.getCube() != null) {
                data.put("cube", chartBase.getCube());
            }
            values.add(data);
        }
        chartValue.setValues(values);
    }

    private static List<ChartDataMetric> getDataMetric(List<Value> values, Map<String, Object> map) {
        ArrayList<ChartDataMetric> dataMetrics = new ArrayList<ChartDataMetric>();
        values.forEach(dimensionValue -> dataMetrics.add(new ChartDataMetric(dimensionValue.getTitle(), dimensionValue.getOriginalName(), dimensionValue.getName(), map.get(dimensionValue.getName()))));
        return dataMetrics;
    }

    public static List<String> sortFiled(List<String> data, String sort, Boolean isTime) {
        if (CollectionUtils.isEmpty(data)) {
            return data;
        }
        if (StringUtils.isEmpty((CharSequence)sort)) {
            return data;
        }
        if (!BooleanUtils.isTrue((Boolean)isTime)) {
            return data;
        }
        String sortData = data.get(0);
        String grain = "";
        for (String s2 : GRAIN_NAME) {
            if (!sortData.contains(s2)) continue;
            grain = s2;
            data = data.stream().map(s1 -> s1.replace(s2, "")).collect(Collectors.toList());
            break;
        }
        if (sort.equals("desc")) {
            data.sort(Comparator.reverseOrder());
        } else {
            data.sort(Comparator.naturalOrder());
        }
        if (StringUtils.isNotEmpty((CharSequence)grain)) {
            String finalGrain = grain;
            data = data.stream().map(s -> s + finalGrain).collect(Collectors.toList());
        }
        return data;
    }
}

