/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.cloud.resources.aop;

import com.digiwin.app.cloud.resources.aop.ServiceInvocationUsageRecorder;
import com.digiwin.app.cloud.resources.aop.UsageRecorderProperties;
import com.digiwin.app.cloud.resources.component.AppIdProvider;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import jakarta.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServiceInvocationUsageMethodInterceptor
implements MethodInterceptor {
    @Autowired
    private ServiceInvocationUsageRecorder recorder;
    private UsageRecorderProperties properties;
    private String uuid;
    private static String RECORD_MARKED_KEY = "crusage-recorder";
    private static Class emptyMapClass = Collections.EMPTY_MAP.getClass();
    public boolean enabled = true;
    private Log log = LogFactory.getLog(ServiceInvocationUsageMethodInterceptor.class);

    public ServiceInvocationUsageMethodInterceptor(UsageRecorderProperties properties) {
        this.uuid = UUID.randomUUID().toString();
        this.properties = properties;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.enabled) {
            this.log("ServiceInvocationUsageMethodInterceptor in...");
            try {
                String requestMethod = null;
                String callerAppId = null;
                HttpServletRequest request = null;
                if (RequestContextHolder.getRequestAttributes() != null) {
                    request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                }
                if (request != null) {
                    HashMap<String, String> profile = DWServiceContext.getContext().getProfile();
                    if (profile == null || emptyMapClass.isInstance(profile)) {
                        profile = new HashMap<String, String>();
                        DWServiceContext.getContext().setProfile(profile);
                    }
                    if (!this.uuid.equalsIgnoreCase((String)profile.get(RECORD_MARKED_KEY))) {
                        profile.put(RECORD_MARKED_KEY, this.uuid);
                        String requestUrl = request.getRequestURI();
                        boolean isEai = this.properties.isEAIEndPoint(requestUrl);
                        boolean isEaiCallback = this.properties.isEAICallbackEndPoint(requestUrl);
                        requestUrl = this.getFinalRequestUrl(isEai, isEaiCallback, request);
                        if (requestUrl != null) {
                            requestMethod = request.getMethod();
                            callerAppId = this.getCallerAppId(invocation, request);
                            String tenantId = (String)profile.get("tenantId");
                            if (tenantId == null) {
                                tenantId = "unknown";
                            }
                            int eventType = 11;
                            SaveEventLog eventLog = new SaveEventLog();
                            eventLog.setAppId("crstatscenter");
                            eventLog.setEventName("srvInv.");
                            eventLog.setEventType(Integer.valueOf(eventType));
                            eventLog.setSysId(callerAppId);
                            eventLog.setEventSource(this.properties.getAppId());
                            eventLog.setMethod(requestMethod);
                            eventLog.setRequestUrl(requestUrl);
                            eventLog.setTenantId(tenantId);
                            HashMap<String, String> data = new HashMap<String, String>();
                            data.put("invokeTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
                            eventLog.setContent(data);
                            this.log("before put event log.");
                            this.recorder.put(eventLog);
                            this.log("after put event log!");
                        }
                    }
                }
            }
            catch (Exception e) {
                this.log.warn((Object)"ServiceInvocationUsageAOP put usage failed!", (Throwable)e);
            }
        }
        this.log("aop proceed...");
        Object result = invocation.proceed();
        this.log("return to aop, process finished!");
        return result;
    }

    private void log(String message) {
        if (this.properties.isLogProcess()) {
            long threadId = Thread.currentThread().threadId();
            String finalMessage = String.format("%s - ServiceInvocationUsageMethodInterceptor - %s", threadId, message);
            this.log.info((Object)finalMessage);
        }
    }

    private String getCallerAppId(MethodInvocation invocation, HttpServletRequest request) {
        String callerAppId = null;
        if (this.properties.isAppIdFromParams()) {
            Object appIdObject = invocation.getArguments()[this.properties.getAppIdIndex()];
            if (appIdObject instanceof String) {
                callerAppId = (String)appIdObject;
            } else if (appIdObject instanceof AppIdProvider) {
                callerAppId = ((AppIdProvider)appIdObject).getAppId();
            } else {
                this.log.error((Object)"\u65e0\u6cd5\u4ece\u53c2\u6570\u4e2d\u83b7\u53d6appId\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6216\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
            }
        } else {
            Map digiHostObject;
            String prodName;
            String digiHost;
            boolean isEai = this.properties.isEAIEndPoint(request.getRequestURI());
            callerAppId = (String)DWServiceContext.getContext().getRequestHeader().get("digi-middleware-appid");
            if (callerAppId == null && isEai && (digiHost = request.getHeader("digi-host")) != null && (prodName = (String)(digiHostObject = (Map)DWGsonProvider.getGson().fromJson(digiHost, Map.class)).get("prod")) != null) {
                callerAppId = prodName;
            }
        }
        if (callerAppId == null) {
            callerAppId = "unknown";
        }
        return callerAppId;
    }

    private String getFinalRequestUrl(boolean isEai, boolean isEaiCallback, HttpServletRequest request) {
        Object isAllowAnonymousObjectValue;
        String requestUrl;
        Object finalRequestUrl = null;
        if (isEai) {
            Map digiServiceObject;
            String name;
            requestUrl = "unknown";
            String digiService = request.getHeader("digi-service");
            if (digiService != null && (name = (String)(digiServiceObject = (Map)DWGsonProvider.getGson().fromJson(digiService, Map.class)).get("name")) != null) {
                requestUrl = name;
            }
            requestUrl = String.format("eai:%s", requestUrl);
        } else if (isEaiCallback) {
            requestUrl = request.getHeader("digi-callback-callback");
            if (requestUrl == null) {
                requestUrl = "unknown";
            }
            requestUrl = String.format("eai-callback:%s", requestUrl);
        } else {
            requestUrl = request.getRequestURI();
        }
        if (this.properties.isExcludeAnonymousAPI() && (isAllowAnonymousObjectValue = request.getAttribute("isDWMethodAllowAnonymous")) instanceof Boolean && ((Boolean)isAllowAnonymousObjectValue).booleanValue()) {
            return null;
        }
        if (!this.properties.isInclude(requestUrl)) {
            return null;
        }
        if (this.properties.isExclude(requestUrl)) {
            return null;
        }
        return finalRequestUrl == null ? requestUrl : finalRequestUrl;
    }
}

