/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.cloud.resources.aop;

import com.digiwin.dap.middleware.lmc.LMCClient;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import java.util.List;
import org.apache.commons.logging.Log;

public class ServiceInvocationUsageUploadRunnable
implements Runnable {
    private Log log;
    private LMCClient lmcClient;
    private List<SaveEventLog> data;

    public ServiceInvocationUsageUploadRunnable(Log log, LMCClient lmcClient, List<SaveEventLog> eventLogList) {
        this.log = log;
        this.lmcClient = lmcClient;
        this.data = eventLogList;
    }

    @Override
    public void run() {
        try {
            this.log.info((Object)("Upload service invocation usage, count = " + this.data.size()));
            this.lmcClient.saveEventLogBatch(this.data);
            this.log.info((Object)">>> Upload finished.");
        }
        catch (Exception e) {
            String name = Thread.currentThread().getName();
            this.log.error((Object)String.format("Thread(name=%s) Upload service invocation usage failed!", name), (Throwable)e);
        }
        this.lmcClient = null;
        this.data = null;
    }
}

