/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.cloud.resources.aop;

import com.digiwin.app.cloud.resources.util.ExcludePatternHelper;
import java.util.HashSet;
import java.util.Set;

public class UsageRecorderProperties {
    private String appId;
    private String eaiEndPointPath;
    private String eaiCallbackEndPointPath;
    private Set<String> excludeSet = new HashSet<String>();
    private Set<String> includeSet = new HashSet<String>();
    private boolean logProcess;
    private boolean excludeAnonymousAPI = false;
    private boolean appIdFromParams;
    private int appIdIndex;

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getEaiEndPointPath() {
        return this.eaiEndPointPath;
    }

    public void setEaiEndPointPath(String eaiEndPointPath) {
        this.eaiEndPointPath = eaiEndPointPath;
    }

    public String getEaiCallbackEndPointPath() {
        return this.eaiCallbackEndPointPath;
    }

    public void setEaiCallbackEndPointPath(String eaiCallbackEndPointPath) {
        this.eaiCallbackEndPointPath = eaiCallbackEndPointPath;
    }

    public boolean isExcludeAnonymousAPI() {
        return this.excludeAnonymousAPI;
    }

    public void setExcludeAnonymousAPI(boolean excludeAnonymousAPI) {
        this.excludeAnonymousAPI = excludeAnonymousAPI;
    }

    public Set<String> getExcludeSet() {
        return this.excludeSet;
    }

    public void setExcludeSet(Set<String> excludeSet) {
        this.excludeSet = excludeSet;
    }

    public Set<String> getIncludeSet() {
        return this.includeSet;
    }

    public void setIncludeSet(Set<String> includeSet) {
        this.includeSet = includeSet;
    }

    public boolean isLogProcess() {
        return this.logProcess;
    }

    public void setLogProcess(boolean logProcess) {
        this.logProcess = logProcess;
    }

    public boolean isEAIEndPoint(String requestUrl) {
        if (requestUrl == null || this.eaiEndPointPath == null) {
            return false;
        }
        return this.eaiEndPointPath.equalsIgnoreCase(requestUrl);
    }

    public boolean isEAICallbackEndPoint(String requestUrl) {
        if (requestUrl == null || this.eaiCallbackEndPointPath == null) {
            return false;
        }
        return this.eaiCallbackEndPointPath.equalsIgnoreCase(requestUrl);
    }

    public boolean isExclude(String requestUrl) {
        if (requestUrl == null) {
            return false;
        }
        for (String pattern : this.excludeSet) {
            if (ExcludePatternHelper.getMatchingPattern(pattern, requestUrl) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isInclude(String requestUrl) {
        if (requestUrl == null) {
            return false;
        }
        if (this.includeSet.size() == 0) {
            return true;
        }
        for (String pattern : this.includeSet) {
            if (ExcludePatternHelper.getMatchingPattern(pattern, requestUrl) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isAppIdFromParams() {
        return this.appIdFromParams;
    }

    public void setAppIdFromParams(boolean appIdFromParams) {
        this.appIdFromParams = appIdFromParams;
    }

    public int getAppIdIndex() {
        return this.appIdIndex;
    }

    public void setAppIdIndex(int appIdIndex) {
        this.appIdIndex = appIdIndex;
    }
}

