/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.cloud.resources.configuration;

import com.digiwin.app.cloud.resources.aop.ServiceInvocationUsageMethodInterceptor;
import com.digiwin.app.cloud.resources.aop.ServiceInvocationUsageRecorder;
import com.digiwin.app.cloud.resources.aop.UsageRecorderProperties;
import com.digiwin.app.cloud.resources.aop.UsageRecorderThreadFactory;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.dap.middleware.lmc.LMCClient;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableScheduling
@ConditionalOnProperty(name={"dap.cloud-resource.usage.service-invocation.enabled"}, havingValue="true", matchIfMissing=false)
public class ServiceInvokeRecordConfiguration {
    private static Log log = LogFactory.getLog(ServiceInvokeRecordConfiguration.class);
    private ServiceInvocationUsageRecorder recorder;

    @Bean
    public DefaultPointcutAdvisor serviceInvokePointcutAdvisor(ServiceInvocationUsageMethodInterceptor serviceInvocationUsageMethodInterceptor) {
        log.info((Object)"ServiceInvokeRecordConfiguration is enabled! prepare ServiceInvocationUsageMethodInterceptor...");
        String expression = "within(com.digiwin.app.service.DWService+)";
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(expression);
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)serviceInvocationUsageMethodInterceptor);
        return advisor;
    }

    @Bean
    public ServiceInvocationUsageRecorder serviceInvocationUsageRecorder(@Autowired Environment environment) {
        ServiceInvocationUsageRecorder recorder;
        int corePoolSize = (Integer)environment.getProperty("dap.cloud-resource.usage.tread-pool.corePoolSize", Integer.class, (Object)5);
        int maximumPoolSize = (Integer)environment.getProperty("dap.cloud-resource.usage.tread-pool.maximumPoolSize", Integer.class, (Object)10);
        long keepAliveTime = (Long)environment.getProperty("dap.cloud-resource.usage.tread-pool.keepAliveTime", Long.class, (Object)30000L);
        int workQueueSize = (Integer)environment.getProperty("dap.cloud-resource.usage.tread-pool.workQueueSize", Integer.class, (Object)5);
        int uploadBatchSize = (Integer)environment.getProperty("dap.cloud-resource.usage.uploadBatchSize", Integer.class, (Object)10);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(workQueueSize), new UsageRecorderThreadFactory("cr-usage-srv-inv"));
        this.recorder = recorder = new ServiceInvocationUsageRecorder(executorService, uploadBatchSize);
        return recorder;
    }

    @Bean
    public ServiceInvocationUsageMethodInterceptor srvInvUsageMethodInterceptor(ObjectProvider<DWEAIProperties> dweaiPropertiesObjectProvider, @Autowired Environment environment) {
        String includeUri;
        UsageRecorderProperties properties = new UsageRecorderProperties();
        properties.setAppId(environment.getProperty("appId", "unknown"));
        DWEAIProperties dweaiProperties = (DWEAIProperties)dweaiPropertiesObjectProvider.getIfAvailable();
        if (dweaiProperties == null) {
            Log log = LogFactory.getLog(ServiceInvokeRecordConfiguration.class);
            log.warn((Object)"ServiceInvokeRecordConfiguration can not get the DWEAIProperties information!");
        } else {
            properties.setEaiEndPointPath(dweaiProperties.getRestfulServicePath());
            properties.setEaiCallbackEndPointPath(dweaiProperties.getRestfulServiceCallbackPath());
        }
        properties.setLogProcess(Boolean.parseBoolean(environment.getProperty("dap.cloud-resource.usage.service-invocation.logProcess")));
        properties.setExcludeAnonymousAPI(Boolean.parseBoolean(environment.getProperty("dap.cloud-resource.usage.service-invocation.exclude-anonymous-api")));
        String excludeUri = environment.getProperty("dap.cloud-resource.usage.service-invocation.exclude", "");
        if (excludeUri.length() > 0) {
            List<String> excludeList = Arrays.asList(excludeUri.split(","));
            properties.setExcludeSet(excludeList.stream().map(String::trim).collect(Collectors.toSet()));
        }
        if ((includeUri = environment.getProperty("dap.cloud-resource.usage.service-invocation.include", "")).length() > 0) {
            List<String> includeList = Arrays.asList(includeUri.split(","));
            properties.setIncludeSet(includeList.stream().map(String::trim).collect(Collectors.toSet()));
        }
        properties.setAppIdFromParams(Boolean.parseBoolean(environment.getProperty("dap.cloud-resource.usage.service-invocation.appid.from.params.enabled")));
        properties.setAppIdIndex(Integer.parseInt(environment.getProperty("dap.cloud-resource.usage.service-invocation.appid.from.params.index", "0")));
        return new ServiceInvocationUsageMethodInterceptor(properties);
    }

    @Bean
    public LMCClient lmcClient(Environment environment) {
        String appId = environment.getProperty("appId");
        String lmcUrl = environment.getProperty("lmcUrl");
        String appToken = environment.getProperty("iamApToken");
        String appSecret = environment.getProperty("iamApSecret");
        return new LMCClient(lmcUrl, appId, appToken, appSecret);
    }

    @Scheduled(cron="${dap.cloud-resource.usage.uploadScheduleCronExpression:0 0/5 * * * *}")
    public void upload() {
        if (this.recorder != null) {
            log.info((Object)"ServiceInvokeRecord scheduled upload...");
            this.recorder.upload();
        }
    }
}

