/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.common;

public class SessionContext {
    private static final ThreadLocal<String> contextHolder = new ThreadLocal();
    private static final ThreadLocal<String> tokenContextHolder = new ThreadLocal();

    SessionContext() {
    }

    public static void clearContext() {
        contextHolder.remove();
    }

    public static String getContext() {
        String ctx = contextHolder.get();
        if (ctx == null) {
            ctx = SessionContext.createEmptyContext();
            contextHolder.set(ctx);
        }
        return ctx;
    }

    public static void setContext(String context) {
        contextHolder.set(context);
    }

    public static String getTokenContext() {
        String ctx = tokenContextHolder.get();
        if (ctx == null) {
            ctx = SessionContext.createEmptyContext();
            tokenContextHolder.set(ctx);
        }
        return ctx;
    }

    public static void setTokenContext(String context) {
        tokenContextHolder.set(context);
    }

    public static String createEmptyContext() {
        return "";
    }
}

