/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.factory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.stereotype.Component;

@Component
public class BeanFactoryContext
implements BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(BeanFactoryContext.class);
    private static BeanFactory beanFactory;

    public static Object findBeanByName(String name) {
        Object obj = null;
        try {
            obj = beanFactory.getBean(name);
        }
        catch (Exception e) {
            log.info(" find bean by name error : {} ", (Throwable)e);
        }
        return obj;
    }

    public static <T> T findBeanByClass(Class<T> cls) {
        Object obj = null;
        try {
            obj = beanFactory.getBean(cls);
        }
        catch (Exception e) {
            log.info(" find bean by class error : {} ", (Throwable)e);
        }
        return (T)obj;
    }

    public static Object containsBean(String name) {
        Boolean obj = null;
        try {
            obj = beanFactory.containsBean(name);
        }
        catch (Exception e) {
            log.info(" locat bean by name error : {} ", (Throwable)e);
        }
        return obj;
    }

    public void setBeanFactory(BeanFactory f) throws BeansException {
        beanFactory = f;
    }
}

