/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums;

import org.springframework.util.ObjectUtils;

public enum AnalysisSourceType {
    DAAS_API(1, "daasApi"),
    DS_WORKFLOW(2, "dsWorkflow");

    private final int code;
    private final String desc;

    private AnalysisSourceType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer code(String name) {
        if (name == null) {
            return null;
        }
        for (AnalysisSourceType ty : AnalysisSourceType.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.name(), (Object)name)) continue;
            return ty.getCode();
        }
        return null;
    }

    public static AnalysisSourceType of(String desc) {
        for (AnalysisSourceType ty : AnalysisSourceType.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.getDesc(), (Object)desc)) continue;
            return ty;
        }
        return null;
    }

    public static Integer of(int type) {
        for (AnalysisSourceType ty : AnalysisSourceType.values()) {
            if (ty.getCode() != type) continue;
            return ty.getCode();
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

