/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.digiwin.commons.entity.vo.lineage.DataLineage;
import com.fasterxml.jackson.databind.ObjectMapper;
import jep.MainInterpreter;
import jep.SharedInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class SqlLineageUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlLineageUtils.class);
    @Value(value="${jepPath}")
    private static String jepPath;
    @Value(value="${sqlLineScriptPath}")
    private static String sqlLineScriptPath;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DataLineage getDataLineage(String sql, String dialect) {
        try (SharedInterpreter interpreter = new SharedInterpreter();){
            interpreter.runScript(sqlLineScriptPath);
            interpreter.set("sql", (Object)sql);
            interpreter.set("dialect", (Object)dialect);
            interpreter.eval("result = get_lineage(sql, dialect)");
            Object result = interpreter.getValue("result");
            ObjectMapper mapper = new ObjectMapper();
            DataLineage dataLineage = (DataLineage)mapper.readValue(mapper.writeValueAsString(result), DataLineage.class);
            return dataLineage;
        }
        catch (Exception e) {
            log.error("sql\u89e3\u6790\u5931\u8d25,\u8bf7\u68c0\u67e5sql");
            throw new RuntimeException(e);
        }
    }

    static {
        MainInterpreter.setJepLibraryPath((String)jepPath);
    }
}

