/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.context;

import cn.hutool.core.lang.Pair;
import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.entity.model.AesSecretKey;
import com.digiwin.commons.entity.model.Result;
import com.digiwin.commons.entity.model.ds.TDapAesSecretKey;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.feign.client.DsService;
import feign.Request;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class AesSecretKeyContext {
    private static final Logger log = LoggerFactory.getLogger(AesSecretKeyContext.class);
    @Autowired
    private DsService dsService;
    private static final Map<Long, Pair<String, String>> SECRET_KEY_MAP = new HashMap<Long, Pair<String, String>>();

    public void refresh() {
        log.info("init Secret Key All");
        Result<List<AesSecretKey>> listResult = this.dsService.selectAesSecretKeyInvalid(new Request.Options(5L, TimeUnit.SECONDS, 20L, TimeUnit.SECONDS, true));
        Optional.ofNullable(listResult).ifPresent(result -> {
            if (!result.getCode().equals(Status.SUCCESS.getCode())) {
                log.error("query ds aes secret key info error\uff01errorInfo:{}", (Object)result.getMsg());
                throw new BusinessException(Status.QUERY_AES_SECRET_KEY_IS_EMPTY_ERROR);
            }
            log.info("refresh Secret Key ");
            AesSecretKeyContext.refreshSecretKeyMap((List)listResult.getData());
        });
        log.info("init Secret Key All end");
    }

    public AesSecretKey initAesSecretKey(Long tenantId) {
        log.info("init Secret Key ");
        Result<TDapAesSecretKey> result = this.dsService.initAesSecretKeyByTenantId(tenantId, new Request.Options(5L, TimeUnit.SECONDS, 20L, TimeUnit.SECONDS, true));
        if (ObjectUtils.isEmpty(result) || !result.getCode().equals(Status.SUCCESS.getCode())) {
            log.error("init ds aes secret key info error\uff01errorInfo:{}", (Object)result.getMsg());
            throw new BusinessException(Status.QUERY_AES_SECRET_KEY_IS_EMPTY_ERROR);
        }
        AesSecretKey aesSecretKey = new AesSecretKey();
        BeanUtils.copyProperties((Object)result.getData(), (Object)aesSecretKey);
        AesSecretKeyContext.refreshSecretKeyMap(Collections.singletonList(aesSecretKey));
        log.info("init Secret Key end");
        return aesSecretKey;
    }

    public static void refreshSecretKeyMap(List<AesSecretKey> aesSecretKeyList) {
        aesSecretKeyList.forEach(aesSecretKey -> {
            Pair secretKeyPair = Pair.of((Object)aesSecretKey.getSecretKey(), (Object)aesSecretKey.getAesKey());
            SECRET_KEY_MAP.put(aesSecretKey.getTenantId(), (Pair<String, String>)secretKeyPair);
        });
    }

    public static String getAesKey(Long tenantId, String secretKey) {
        Pair<String, String> secretKeyPair = AesSecretKeyContext.getAesKeyPair(tenantId);
        String key = (String)secretKeyPair.getKey();
        if (!ObjectUtils.nullSafeEquals((Object)key, (Object)secretKey)) {
            throw new BusinessException(Status.AES_SECRET_KEY_IS_INVALID_ERROR);
        }
        return (String)secretKeyPair.getValue();
    }

    public static String getAesKey(Long tenantId) {
        return (String)AesSecretKeyContext.getAesKeyPair(tenantId).getValue();
    }

    public static Pair<String, String> getAesKeyPair(Long tenantId) {
        return SECRET_KEY_MAP.get(tenantId);
    }

    @Autowired
    public AesSecretKeyContext() {
    }
}

