/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.feign.client;

import com.digiwin.commons.entity.dto.BatchUpdateFieldInfoDto;
import com.digiwin.commons.entity.dto.DetailListDto;
import com.digiwin.commons.entity.dto.meta.DataInfoDto;
import com.digiwin.commons.entity.dto.meta.SearchDmpAssetInfoDTO;
import com.digiwin.commons.entity.dto.meta.SearchTableDto;
import com.digiwin.commons.entity.dto.meta.TableApiQuoteDto;
import com.digiwin.commons.entity.enums.DbType;
import com.digiwin.commons.entity.model.Result;
import com.digiwin.commons.entity.model.TMetaReadWriteLog;
import com.digiwin.commons.entity.model.TMetaTableAccessLog;
import com.digiwin.commons.entity.model.TMetaTablePartitionLog;
import com.digiwin.commons.entity.model.ds.TDapTableStorageDaily;
import com.digiwin.commons.entity.vo.DetailListVo;
import com.digiwin.commons.entity.vo.DmpFullDataVO;
import com.digiwin.commons.entity.vo.RelationTableTagVO;
import com.digiwin.commons.entity.vo.assets.DmpAssetInfoVO;
import com.digiwin.commons.feign.conf.FeignGlobalConfig;
import com.digiwin.commons.utils.PageInfo;
import feign.Request;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ConditionalOnDiscoveryEnabled
@ConditionalOnProperty(name={"meta.feign.enable"}, havingValue="true", matchIfMissing=true)
@FeignClient(contextId="meta-api-service", value="meta-api-service", path="/meta/api", configuration={FeignGlobalConfig.class})
public interface MetaService {
    @RequestMapping(value={"${meta.api.hive-data-overview}"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<DataInfoDto> queryDataInfo(@RequestParam(value="dbType", defaultValue="HIVE") DbType var1, @RequestParam(value="dbName", defaultValue="") String var2, @RequestParam(value="datasourceId", defaultValue="") Integer var3);

    @RequestMapping(value={"${meta.api.query-table-guid}"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<String> queryAtlasTableGuid(@RequestParam(value="qualifiedName") String var1);

    @GetMapping(value={"${meta.api.search-no-participle}"})
    public Result<List<DmpFullDataVO>> searchNoParticipleEsInfo(@RequestParam(value="searchType", defaultValue="0") Integer var1, @RequestParam(value="content", defaultValue="") String var2, @RequestParam(value="dbType", defaultValue="HIVE") DbType var3, @RequestParam(value="dbName", defaultValue="") Integer var4, @RequestParam(value="datasourceId", defaultValue="") Integer var5);

    @PostMapping(value={"${meta.api.log-table-api}"})
    public Result statisticsApiOrWorkflow(@RequestBody List<TableApiQuoteDto> var1);

    @PostMapping(value={"${meta.api.update-tag}"})
    public Result updateTagByEsRest(@RequestBody RelationTableTagVO var1);

    @PostMapping(value={"${meta.api.access-log-batch-save}"})
    public Result batchSaveAccessLog(@RequestBody List<TMetaTableAccessLog> var1);

    @PostMapping(value={"${meta.api.batch-query-table-info}"})
    public Result<List<DmpFullDataVO>> batchQueryTableInfo(@RequestBody SearchTableDto var1);

    @PostMapping(value={"${meta.api.add-alter-log}"})
    public Result addTablePartitionLog(@RequestBody TMetaTablePartitionLog var1);

    @GetMapping(value={"${meta.api.delete-by-guid}"})
    public Result deleteByGuid(@RequestParam(value="tableGuid") String var1);

    @GetMapping(value={"${meta.api.save-or-update}"})
    public Result metaTableInfoSaveOrUpdate(@RequestParam(value="tableGuid") String var1, @RequestParam(value="dbName") String var2, @RequestParam(value="tableCode") String var3, @RequestParam(value="addFlag", defaultValue="false") Boolean var4, Request.Options var5);

    @PostMapping(value={"${meta.api.query-table-total-storage}"})
    public Result<List<TDapTableStorageDaily>> queryTableTotalStorage(@RequestBody List<TDapTableStorageDaily> var1, Request.Options var2);

    @PostMapping(value={"${meta.api.batch-update-field-info}"})
    public Result batchUpdateFieldInfo(@RequestBody BatchUpdateFieldInfoDto var1, Request.Options var2);

    @PostMapping(value={"${meta.api.update-table-list-field-info}"})
    public Result updateTableListFieldInfo(@RequestBody List<BatchUpdateFieldInfoDto> var1);

    @PostMapping(value={"${meta.api.list-asset-by-param}"})
    public Result<PageInfo<DmpAssetInfoVO>> listAssetByParam(@RequestBody SearchDmpAssetInfoDTO var1, Request.Options var2);

    @PostMapping(value={"${meta.api.get-field-detail-list}"})
    public Result<PageInfo<DetailListVo>> getFieldDetailList(@RequestBody DetailListDto var1, Request.Options var2);

    @PostMapping(value={"${meta.api.read-write-batch-save}"})
    public Result batchSave(@RequestBody List<TMetaReadWriteLog> var1);

    @PostMapping(value={"${meta.api.bool-query-es-dmpasset}"})
    public Result<List<DmpAssetInfoVO>> boolQueryEsDmpAsset(@RequestBody SearchDmpAssetInfoDTO var1);
}

