/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.aspect;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.commons.annotation.TrackingPoint;
import com.digiwin.commons.context.OperationLogContext;
import com.digiwin.commons.context.SpringApplicationContext;
import com.digiwin.commons.context.UserInfoContext;
import com.digiwin.commons.entity.enums.EsOprationTypeEnum;
import com.digiwin.commons.entity.enums.ServerModuleEnum;
import com.digiwin.commons.entity.enums.TrackingType;
import com.digiwin.commons.entity.model.OperationLogPersists;
import com.digiwin.commons.entity.model.UserInfo;
import com.digiwin.commons.entity.model.es.DocInsert;
import com.digiwin.commons.entity.model.es.DocOperationBase;
import com.digiwin.commons.feign.client.DaasService;
import com.digiwin.commons.utils.ELUtils;
import com.digiwin.commons.utils.JSONUtils;
import com.digiwin.commons.utils.StringUtils;
import feign.Request;
import io.swagger.annotations.ApiOperation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.skywalking.apm.toolkit.trace.Trace;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Order(value=10)
@Component
@ConditionalOnProperty(name={"log.aspect.enable"}, havingValue="true", matchIfMissing=true)
public class SensitiveOperationLogAspect {
    private static final Logger log = LoggerFactory.getLogger(SensitiveOperationLogAspect.class);
    private static final String KEY_ID = "id";
    @Autowired
    DaasService daasService;
    @Value(value="${default.elastic.operation-log-index-name:dmp_operation_log}")
    private String operationLogIndexName;

    @Pointcut(value="@annotation(com.digiwin.commons.annotation.TrackingPoint)")
    public void pointcut() {
    }

    @Trace
    @Before(value="pointcut()")
    public void preProceeding(JoinPoint joinPoint) {
        OperationLogPersists.OperationLogPersistsBuilder builder = OperationLogPersists.builder();
        builder.reqTime(LocalDateTime.now());
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        TrackingPoint trackingPoint = method.getAnnotation(TrackingPoint.class);
        if (Objects.isNull(trackingPoint)) {
            return;
        }
        try {
            String notes = Optional.ofNullable(trackingPoint.title()).filter(StringUtils::isNotBlank).orElseGet(() -> Optional.ofNullable(method.getAnnotation(ApiOperation.class)).map(i -> i.notes()).filter(StringUtils::isNotBlank).orElse(""));
            TrackingType trackingType = trackingPoint.trackingType();
            switch (trackingType) {
                case UPDATE: 
                case DELETE: {
                    SensitiveOperationLogAspect.getOldModuleObject(joinPoint, trackingPoint, builder);
                }
            }
            ServerModuleEnum serverModuleEnum = trackingPoint.serverModule();
            UserInfo userInfo = UserInfoContext.getContext();
            String traceId = TraceContext.traceId();
            OperationLogPersists opLog = builder.traceId(traceId).userInfo(userInfo).serverModule(serverModuleEnum).trackingType(trackingType).methodDesc(notes).build();
            OperationLogContext.setContext(opLog);
            log.info("moduleAlice: {} , operation: {} ,user : {}", new Object[]{serverModuleEnum.getDesc(), trackingType, userInfo});
        }
        catch (Exception e) {
            log.error("SensitiveOperationLogAspect preProceeding error ,e :{} ", (Throwable)e);
        }
    }

    private static Object getOldModuleObject(JoinPoint joinPoint, TrackingPoint trackingPoint, OperationLogPersists.OperationLogPersistsBuilder builder) {
        Object[] args = joinPoint.getArgs();
        Object serializeId = SensitiveOperationLogAspect.getSerializeIdFromRequest(joinPoint, trackingPoint);
        Object bean = SpringApplicationContext.getBean(trackingPoint.tracker());
        String expression = TrackingPoint.Expression.getTrackingEL(serializeId.toString());
        Object oldData = ELUtils.eval(expression, bean);
        return builder.newData(JSON.toJSONString((Object)args[0])).rowData(JSON.toJSONString((Object)oldData));
    }

    @AfterReturning(value="pointcut()", returning="result")
    public void afterReturning(JoinPoint joinPoint, Object result) {
        this.postProceeding(result, null);
    }

    @AfterThrowing(value="pointcut()", throwing="ex")
    public void afterReturning(JoinPoint joinPoint, Throwable ex) {
        this.postProceeding(null, ex);
    }

    private void postProceeding(Object result, Throwable ex) {
        OperationLogPersists context = OperationLogContext.getContext();
        LocalDateTime now = LocalDateTime.now();
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        context.setId(StringUtils.uuid());
        context.setIp(request.getRemoteAddr());
        context.setUrl(request.getRequestURL().toString());
        context.setMethod(request.getMethod());
        context.setReqEndTime(now);
        context.setElapse(LocalDateTimeUtil.between((LocalDateTime)context.getReqTime(), (LocalDateTime)now, (ChronoUnit)ChronoUnit.MILLIS));
        Optional.ofNullable(ex).map(i -> i.getMessage()).ifPresent(context::setErrorMsg);
        Optional.ofNullable(result).filter(Objects::nonNull).ifPresent(context::setResult);
        OperationLogContext.clearContext();
        log.info("OperationLogPersists :{}", (Object)context);
        DocOperationBase dmpOperationLog = ((DocInsert.DocInsertBuilder)((DocOperationBase.DocOperationBaseBuilder)((DocInsert.DocInsertBuilder)DocInsert.builder().index(this.operationLogIndexName)).dataMap(Collections.singletonMap(context.getId(), JSONUtils.toJsonString(context)))).esOprationTypeEnum(EsOprationTypeEnum.REST_CLIENT)).build();
        try {
            this.daasService.saveEsInfo((DocInsert)dmpOperationLog, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
        }
        catch (Exception e) {
            log.error("save es info :{}", (Throwable)e);
        }
    }

    private static Object getSerializeIdFromRequest(JoinPoint joinPoint, TrackingPoint trackingPoint) {
        Object[] args = joinPoint.getArgs();
        Object id = null;
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        block0: for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (annotation.annotationType() != RequestBody.class) continue;
                id = ELUtils.eval(trackingPoint.id(), args[i]);
                break block0;
            }
        }
        return Optional.ofNullable(id).filter(Objects::nonNull).orElseGet(() -> {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest request = attributes.getRequest();
            return request.getParameter(KEY_ID);
        });
    }
}

