/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.alibaba.fastjson.JSON;
import com.digiwin.commons.entity.enums.DbType;
import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.entity.model.datasource.BaseDataSource;
import com.digiwin.commons.entity.model.datasource.ClickHouseDataSource;
import com.digiwin.commons.entity.model.datasource.DB2ServerDataSource;
import com.digiwin.commons.entity.model.datasource.HiveDataSource;
import com.digiwin.commons.entity.model.datasource.ImpalaDataSource;
import com.digiwin.commons.entity.model.datasource.MySQLDataSource;
import com.digiwin.commons.entity.model.datasource.OracleDataSource;
import com.digiwin.commons.entity.model.datasource.PostgreDataSource;
import com.digiwin.commons.entity.model.datasource.SQLServerDataSource;
import com.digiwin.commons.entity.model.datasource.SparkDataSource;
import com.digiwin.commons.exceptions.BusinessException;
import java.sql.Connection;
import java.sql.DriverManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBConnUtils {
    private static final Logger log = LoggerFactory.getLogger(DBConnUtils.class);

    public Connection getConnection(DbType dbType, String parameter) {
        Connection connection = null;
        BaseDataSource datasource = null;
        try {
            switch (dbType) {
                case POSTGRESQL: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, PostgreDataSource.class);
                    Class.forName("org.postgresql.Driver");
                    break;
                }
                case MYSQL: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, MySQLDataSource.class);
                    Class.forName("com.mysql.jdbc.Driver");
                    break;
                }
                case HIVE: 
                case SPARK: {
                    if (dbType == DbType.HIVE) {
                        datasource = (BaseDataSource)JSON.parseObject((String)parameter, HiveDataSource.class);
                    } else if (dbType == DbType.SPARK) {
                        datasource = (BaseDataSource)JSON.parseObject((String)parameter, SparkDataSource.class);
                    }
                    Class.forName("org.apache.hive.jdbc.HiveDriver");
                    break;
                }
                case IMPALA: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, ImpalaDataSource.class);
                    Class.forName("com.cloudera.impala.jdbc41.Driver");
                    break;
                }
                case CLICKHOUSE: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, ClickHouseDataSource.class);
                    Class.forName("ru.yandex.clickhouse.ClickHouseDriver");
                    break;
                }
                case ORACLE: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, OracleDataSource.class);
                    Class.forName("oracle.jdbc.driver.OracleDriver");
                    break;
                }
                case SQLSERVER: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, SQLServerDataSource.class);
                    Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
                    break;
                }
                case DB2: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, DB2ServerDataSource.class);
                    Class.forName("com.ibm.db2.jcc.DB2Driver");
                    break;
                }
            }
            if (datasource != null) {
                log.info("jdbcurl : {} , user : {} , password : {}", new Object[]{datasource.getJdbcUrl(), datasource.getUser(), datasource.getPassword()});
                connection = DriverManager.getConnection(datasource.getJdbcUrl(), datasource.getUser(), datasource.getPassword());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException(Status.DATA_SOURCE_CONNECTION_ERROR);
        }
        return connection;
    }
}

