/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import cn.hutool.crypto.digest.DigestUtil;
import java.util.Objects;
import java.util.UUID;

public class StringUtils {
    public static final String EMPTY = "";

    private StringUtils() {
        throw new UnsupportedOperationException("Construct StringUtils");
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isBlank(String s) {
        if (StringUtils.isEmpty(s)) {
            return true;
        }
        return s.trim().length() == 0;
    }

    public static boolean isNotBlank(String s) {
        return !StringUtils.isBlank(s);
    }

    public static String replaceNRTtoUnderline(String src) {
        if (StringUtils.isBlank(src)) {
            return src;
        }
        return src.replaceAll("[\n|\r|\t]", "_");
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replace("-", EMPTY);
    }

    public static boolean notNull(Object obj) {
        return Objects.nonNull(obj) && !"null".equals(obj) && StringUtils.isNotBlank(obj.toString());
    }

    public static String getNewTraceID() {
        return DigestUtil.md5Hex16((String)UUID.randomUUID().toString());
    }

    public static StringBuilder removeLastComma(StringBuilder sb) {
        if (sb.toString().endsWith(",")) {
            sb.setLength(sb.length() - 1);
        }
        return sb;
    }
}

